import {createGlobalStyle, css} from 'styled-components';
import {Black, hover, text, title} from './globalStyleVars';

function createCSS() {
    let styles = '';

    for (let i = 2; i < 20; i += 1) {
        styles += `
        .anim-active.fade-up:nth-child(${i}) {
          transition-delay: ${i * .12}s;
        }
     `
    }

    for (let a = 2; a < 100; a += 1) {
        styles += `
        .anim-active.fade-right span:nth-child(${a}) {
          transition-delay: ${a * .03}s;
        }
     `
    }

    return css`${styles}`;
}

export default createGlobalStyle`

    //html{
    //    overflow-x: hidden !important;
    //    
    //    &.menu-open{
    //        overflow-y: hidden;
    //    }
    //}
    
    ${createCSS()}
    #root {
        min-height: 100vh;
        overflow-x: hidden;
    }

    ::-webkit-scrollbar {
        width: 0; /* Adjusted the width to be smaller */
    }



    body {
        font-family: 'Verdana', Arial, Helvetica, freesans, sans-serif !important;
        font-style: normal;
        font-weight: 500;
        margin: 0;
        color: ${text};
        padding: 0;
        overflow-x: hidden;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        min-height: 100vh;
        font-size: 16px;
        line-height: 20px;
        background-color: #f0f0f0;
    }

    a {
        transition: color .3s ease;
        text-decoration: none;

        &:hover {
            color: ${hover} !important;
            text-decoration: none;
            outline: none;
            box-shadow: none;
        }

        &:focus {
            text-decoration: none;
            outline: none;
            box-shadow: none;
            color: ${text};
        }
    }

    ::selection {
        background: ${hover};
        color: #FFF;
    }

    p, a, h1, h2, h4, h3, h5, h6 {
        font-weight: 400;
        margin: 0;
    }

    h1 {
        font-family: ${title};
        font-size: 68px;
        line-height: 68px;
        font-weight: 600;

        @media(max-width: 767px) {
            font-size: 40px;
            line-height: 40px;
        }
    }
    h2 {
        font-family: ${title};
        font-size: 60px;
        line-height: 60px;
        font-weight: 600;
        @media(max-width: 767px) {
            font-size: 36px;
            line-height: 36px;
        }
    }

    h3{
        font-family: ${title};
        font-size: 40px;
        line-height: 60px;
        font-weight: 500;
        @media(max-width: 767px) {
            font-size: 30px;
            line-height: 30px;
            font-weight: 600;
        }
    }

    h4{
        font-family: ${title};
        font-size: 32px;
        line-height: 120%;
        font-weight: 600;
        @media(max-width: 767px) {
            font-size: 28px;
            //line-height: 42px;
        }
    }

    h5{
        font-family: ${title};
        font-size: 24px;
        line-height: 24px;
        font-weight: 600;
        @media(max-width: 767px) {
            font-size: 20px;
        }
    }

    h6{
        font-family: ${title};
        font-size: 20px;
        line-height: 24px;
        font-weight: 400;
        @media(max-width: 767px) {
            font-size: 18px;
        }
    }

    ul {
        margin: 0;
        padding: 0
    }

    li {
        list-style: none;
    }

    img {
        max-width: 100%;
        object-fit: contain;
    }


    .btn:focus, button:focus, button:active:focus, .btn.active.focus, .btn.active:focus, .btn.focus, .btn:active.focus, .btn:active:focus, .btn:focus {
        outline: none;
        box-shadow: none;
    }

    input:-webkit-autofill,
    input:-webkit-autofill:hover,
    input:-webkit-autofill:focus,
    textarea:-webkit-autofill,
    textarea:-webkit-autofill:hover,
    textarea:-webkit-autofill:focus,
    select:-webkit-autofill,
    select:-webkit-autofill:hover,
    select:-webkit-autofill:focus {
        border: 1px solid rgba(0, 0, 0, 0);
        -webkit-text-fill-color: #000;
        -webkit-box-shadow: 0 0 0px 1000px rgba(0, 0, 0, 0) inset;
        transition: background-color 5000s ease-in-out 0s;
    }


    table {
        width: 100%;
    }

    form div {
        position: relative;
    }

    .form-control {
        box-shadow: none;
        outline: 0;
        border-radius: 0;

        &:focus {
            box-shadow: none;
        }
    }

    .p-0 {
        padding: 0 !important;
    }

    .pl-0 {
        padding-left: 0;
    }

    .pr-0 {
        padding-right: 0;
    }

    .pt-200 {
        padding-top: 200px;
        @media (max-width: 767px) {
            padding-top: 120px;
        }
    }

    .pb-200 {
        padding-bottom: 200px;
        @media (max-width: 767px) {
            padding-bottom: 120px;
        }
    }

    .pt-160 {
        padding-top: 160px;
        @media (max-width: 767px) {
            padding-top: 100px;
        }
    }

    .pb-160 {
        padding-bottom: 160px;
        @media (max-width: 767px) {
            padding-bottom: 100px;
        }
    }

    .pt-150 {
        padding-top: 150px;
        @media (max-width: 767px) {
            padding-top: 100px;
        }
    }

    .pb-150 {
        padding-bottom: 150px;
        @media (max-width: 767px) {
            padding-bottom: 100px;
        }
    }

    .pb-120 {
        padding-bottom: 120px;
        @media (max-width: 767px) {
            padding-bottom: 80px;
        }
    }
    .pt-120 {
        padding-top: 120px;
        @media (max-width: 767px) {
            padding-top: 80px;
        }
    }

    .pt-100 {
        padding-top: 100px;
        @media (max-width: 767px) {
            padding-top: 80px;
        }
    }

    .pb-100 {
        padding-bottom: 100px;
        @media (max-width: 767px) {
            padding-bottom: 80px;
        }
    }

    .pt-80 {
        padding-top: 80px;
        @media (max-width: 767px) {
            padding-top: 40px;
        }
    }

    .pb-80 {
        padding-bottom: 80px;
        @media (max-width: 767px) {
            padding-bottom: 40px;
        }
    }

    .mt-20 {
        margin-top: 20px;
    }

    .mt-40 {
        margin-top: 40px;
    }

    .mt-60 {
        margin-top: 60px;
    }


    @media (min-width: 1500px) {
        .container {
            min-width: 85%;
            margin: auto;
        }
    }

    @media (max-width: 1199px) and (min-width: 768px) {
        .container, .container-lg, .container-md, .container-sm {
            max-width: 90%;
            margin: auto;
        }
    }


    @media (max-width: 767px) {
        .container, .container-sm {
            max-width: 100%;
        }
    }

    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    /* Firefox */
    input[type=number] {
        -moz-appearance: textfield;
    }


    //react select
    .css-yk16xz-control, .css-1pahdxg-control {
        height: 50px;
        border-radius: 0 !important;
        padding-left: 5px;
        font-size: 16px;
        outline: none !important;
        border-color: #D9D9D9 !important;
        box-shadow: none !important;

        .css-1wa3eu0-placeholder {
            font-weight: 300;
            line-height: 21px;
            color: rgba(0, 0, 0, 0.5);
            outline: none;
        }

        .css-1okebmr-indicatorSeparator {
            display: none;
        }

        .css-tlfecz-indicatorContainer, .css-1gtu0rj-indicatorContainer {
            margin-right: 10px;
        }
    }

    .css-2613qy-menu {
        border-radius: 0 !important;
        margin-top: 0 !important;
    }


    .info-window {
        max-width: 200px;
    }

    .gm-style-iw {
        border-radius: 0 !important;
    }

    .swiper-pagination-bullet {
        outline: none;
    }

    .css-nmuc1a-menu {
        z-index: 5 !important;
    }


    .map-info__img {
        img {
            height: 100px;
            margin-bottom: 12px;
            object-fit: cover;
        }
    }

    .map-info__content {
        h4 {
            font-size: 20px;
        }

        p {
            margin-bottom: 5px;
        }
    }

    .overlay {
        position: fixed;
        height: 100vh;
        width: 100%;
        //background-color: rgba(0,0,0,0.5);
        top: 0;
        bottom: 0;
        left: 0;
        z-index: 9;
        display: none;

        &.show {
            display: block;
        }
    }

    .form-control.has-error {
        border-color: #dc004e !important;
    }

    .has-error .find-retainer-filter__control {
        border-color: #dc004e !important;
    }

    //preloader
    .content-loader {
        position: absolute;
        height: 70%;
        width: 70%;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        justify-content: center;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
        margin: auto;
    }

    .loading-before-submit {
        position: fixed;
        height: 100vh;
        width: 100%;
        bottom: 0;
        top: 0;
        left: 0;
        background: rgba(0, 0, 0, 0.65);
        z-index: 9;
        display: flex;
        align-items: center;
        justify-content: center;

        img {
            height: 40px;
        }
    }


    .swiper-slide {
        height: auto;
    }

    .slick-slide {
        div {
            outline: none !important
        }
    }

    button, button:active, button:focus, button:focus-visible {
        outline: none !important;
        box-shadow: none !important;
    }


    .hover {
        position: relative;
        overflow: hidden;

        span {
            z-index: 2;
        }

        &:after {
            content: '';
            position: absolute;
            height: 0;
            width: 0;
            left: 0;
            right: 0;
            top: 0;
            bottom: 0;
            margin: auto;
            background-color: ${hover};
            transition: all .5s ease;
            border-radius: 50%;
        }

        &:hover {
            &:after {
                height: 100%;
                width: 100%;
            }
        }
    }


    .modal-backdrop {
        background-color: rgb(34 31 31 / 90%);
        min-width: 100%;
        //z-index: 9999;

        &.show {
            opacity: 1;
        }
    }


    .valid {
        color: ${hover};
        position: absolute;
        font-size: 12px;
        top: 44px;
    }

    input[type="number"]::-webkit-outer-spin-button,
    input[type="number"]::-webkit-inner-spin-button {
        -webkit-appearance: none;
    }


    //menu fixed
    .scroll-down .menu-desktop {
        transform: translate3d(0, -100%, 0);
    }

    .scroll-up .menu-desktop {

    }

    .form-control:disabled {
        background-color: transparent;
    }

    @media (max-width: 600px) {
        .prevent-overflow {
            overflow: hidden;
            height: 100vh;
        }
    }

    .Toastify__toast-container {
        z-index: 99999999;
    }

    .mobile-menu {
        #fb-root, .fb_reset {
            display: none !important;
            opacity: 0 !important;
            visibility: hidden !important;
        }
    }

    .slick-slide {
        -webkit-transform: translate3d(0, 0, 0);
    }


    //------------------------animation
    .split-parent {
        overflow: hidden;
    }

    .split-child {
        overflow: hidden;
    }

    .reveal {
        overflow: hidden;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;

        img {
            transform-origin: left;
        }

        .global-image {
            background: transparent;
        }
    }

    #smooth-content {
        will-change: transform;
    }

    .page-transition {
        display: none;
    }

    form {
        .form-group{
            //padding: 0 0 20px 0;
            margin-bottom: 40px;
        }
        .form-control {
            padding: 0;
            border: none;
            border-bottom: 1px solid rgba(255, 255, 255, 0.3);
            background-color: transparent !important;
            outline: none;
            color: #ffffff;
            box-shadow: none;

            &::placeholder {
                color: #999999;
            }

            &:focus {
                border-color: #FFF;
            }
        }

        textarea {
            padding: 0 !important;
            min-height: 80px;
            max-height: 80px;
        }
    }

    .modify-footer .footer {
        @media (min-width: 600px) {
            padding-top: 200px;
        }
    }

    //global form
    .global-popup form .form-control {
        border-bottom: 1px solid rgba(10, 14, 18, 0.3);
        color: ${Black};
        padding: 0 0 15px 0;
        margin-bottom: 30px;

        &::placeholder {
            color: #999999 !important;
            text-transform: capitalize;
        }

        &:focus {
            border-bottom: 1px solid ${Black};
        }
    }

    .services {
        background-color: ${Black};

        .working, .insights {
            padding-top: 0;
        }

        .amenities {
            @media (max-width: 992px) {
                padding-top: 0;
            }
        }
    }

    .career-detail {
        background-color: ${Black};
        padding-top: 140px;
        padding-bottom: 150px;
        overflow: hidden;
    }

    .team-bio {
        background-color: ${Black};
        padding-top: 140px;
    }


    //Director Popup
    .popup-version-one {
        z-index: 9999 !important;
        -ms-overflow-style: none !important;
        scrollbar-width: none !important;
        .modal-dialog{
            max-width: 100% !important;
            margin: 0 !important;
            overflow: hidden !important;
        }


        .modal-content{
            width: 100vw !important;
        }

        .for-close{
            align-items: center;
            padding-top: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #000;
            margin-bottom: 60px;
            cursor: pointer;
        }
        .modal-close {
            height: 40px;
            width: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            border: 1px solid #000000;
            position: relative;
            overflow: hidden;
            transition: .3s ease;



            svg {

            }

            &:after {
                content: '';
                position: absolute;
                height: 0;
                width: 0;
                left: 0;
                right: 0;
                top: 0;
                bottom: 0;
                margin: auto;
                background-color: #00167D;
                transition: all .5s ease;
                border-radius: 19px;
            }

            &:hover {
                border-color: #00167D;

                svg{
                    position: relative;
                    z-index: 999;
                    g{
                        line{
                            stroke: #ffffff;
                        }
                    }
                }

                &:after {
                    width: 100%;
                    height: 100%;
                }
            }
        }

        .modal-body{
            padding-bottom: 60px;
            .modal-data{
                width: 100%;
                flex-wrap: wrap;

                &__content{
                    padding-right: 70px;
                    overflow-y: hidden;

                    h2{
                        color: #00167D;
                        font-size: 60px;
                        font-style: normal;
                        font-weight: 700;
                        line-height: 100%; /* 60px */
                        margin-bottom: 40px;
                    }

                    p{
                        color: #000;
                        font-size: 16px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 150% */
                    }
                }

                &__img{
                    .image-wrapper{
                        position: relative;
                        padding-top: calc(420 / 370 * 100%);
                        overflow: hidden;
                        margin-bottom: 20px;
                    }
                }
            }
        }

        @media (max-width: 767px) {

            .bar{
                padding-left: 0;
            }

            .for-close{
                margin-bottom: 30px;
            }
            .modal-content {
                overflow-x: hidden;

                h2{
                    font-size: 36px !important;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100% !important; /* 36px */
                }

                .modal-body{
                    .bar{
                        padding-right: 0 !important;
                    }
                }
                .modal-data__content{
                    padding-right: 0 !important;
                    overflow: hidden;
                }
                .modal-data__img{
                    padding-right: 0 !important;
                }
            }

            .modal-close {
                right: 15px !important;
            }

            .modal-data {
                flex-wrap: wrap;
                flex-direction: column-reverse;

                .modal-data__img {
                    padding-left: 0;
                    min-width: 100%;
                }
            }

            .modal-data__content {
                padding-left: 0;
                //padding-left: 15px;
                //min-width: 100%;
                //margin: 20px 0 100px 0;
                padding-right: 15px !important;
                padding-bottom: 40px;
            }
        }

    }


    .scroll-down .main-menu {
        transform: translate3d(0, -100%, 0);
    }
    
    
    .scroll-up{
        .main-menu{
            background-color: #ffffff;
            border-bottom: 1px solid #00198f;
            transition: all 0.3s ease-in-out;
            &__items{
                &__left{
                    svg{
                        path{
                            fill: #00198f !important;
                            transition: all 0.6s ease-in-out;
                        }
                        //g{
                        //    &:nth-of-type(2){
                        //        fill: #00167D;
                        //        stroke: transparent;
                        //        animation: qode-logo 4s infinite forwards;
                        //        -webkit-clipPath: inset(0 100% 0 0);
                        //        clipPath: inset(0 100% 0 0);
                        //    }
                        //}
                    }
                }
                
                &__right{
                    .hamburger{
                        border: 1px solid #00198f;
                        span{
                            background-color: #00198f;
                            transition: all 0.6s cubic-bezier(0.4, 0, 0, 1);
                        }
                    }
                }
            }
        }
    }
    
    
    .menu-open{
        overflow: hidden;
    }


    //team popup
    .team-modal {
        background-color: #25292C;
        height: 100vh;
        z-index: 99999;
        overflow: hidden !important;
        width: 45%;
        right: 0;
        left: auto;
        padding: 0px 70px 30px 70px !important;

        &__close {
            height: 37px;
            width: 37px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            background-color: transparent;
            border: 1px solid #ffffff;
            border-radius: 50%;
            position: absolute;
            right: -10px;
            top: -60px;
            transition: .3s ease;

            &:hover {
                background-color: ${hover};
            }
        }

        .modal-dialog {
            height: 100vh;
            background-color: transparent;
            min-width: 100%;
            margin: 0;
        }

        .modal-body {
            height: 100vh;
        }

        .modal-content {
            background-color: transparent;
            margin: 100px 0;
            //overflow: scroll;
            //height: calc(100vh - 120px);
            border: none;

            .team-modal__content {
                h4 {
                    color: #f5f5f5;
                    font-size: 20px;
                    font-weight: 600;
                    margin-top: 24px;
                    //border-top: 1px solid rgba(245, 245, 245, 0.2);
                    margin-bottom: 5px;
                }

                h5 {
                    color: rgba(245, 245, 245, 0.5);
                    font-size: 16px;
                    margin-bottom: 25px;
                }

                p {
                    color: #f5f5f5;
                    margin-bottom: 20px;
                }

                ul {
                    display: flex;
                    margin-top: 20px;
                    margin-bottom: 20px;

                    li {
                        &:not(:nth-last-child(1)) {
                            margin-right: 20px;
                        }

                        a {
                            transition: opacity .5s ease;

                            &:hover {
                                // rect {
                                    //   fill: ${text}
                                // }
                                //
                                // path {
                                    //   fill: ${White}
                                // }
                                opacity: .7;
                            }
                        }

                    }
                }
            }
        }

        @media (max-width: 767px) {
            width: 100%;
            padding: 0 20px 10px 20px !important;
            .close-button {
                right: 20px;
                position: fixed;
            }

            .modal-content {
                //padding-top: 80px;

                .container {
                    //height: calc(100vh - 100px);
                    //overflow: scroll;

                    h3 {
                        margin-top: 30px;
                        font-size: 28px;
                        line-height: 35px;
                    }
                }
            }

            //overflow: scroll !important;

        }
    }


    .simplebar-scrollbar:before {
        background-color: #FFF !important;
    }

    .simplebar-track.simplebar-vertical {
        width: 7px;
    }

    .simplebar-track {
        right: -7px;
    }


    //video modal
    .modal-video {
        background-color: transparent;
        height: 100vh;
        z-index: 99999;

        .modal-dialog {
            height: 100vh;
            background-color: transparent;
            min-width: 100%;
            margin: 0;
        }

        .modal-body {
            height: 100vh;
        }

        .modal-content {
            background-color: transparent;

        }

        iframe {
            height: 60vh;
            width: 60vw;
            margin: auto;
            position: absolute;
            inset: 0;
        }

        .close-modal {
            position: absolute;
            top: 40px;
            right: 30px;
            height: 30px;
            cursor: pointer;
            z-index: 99;
        }

        @media (max-width: 768px) {
            .modal-content {
                //padding: 0 20px;

                iframe {
                    width: 90vw;
                    height: 60vh;
                }

                .close-modal {
                    top: 80px;
                    right: 20px;
                }
            }
        }
        @media (max-width: 550px) {
            .modal-content iframe {
                width: 90vw;
                height: 40vh;
            }
        }
    }


    .ask.modal{
        z-index:99999999;
        overflow: hidden;
        padding-right: 0 !important;

        .contact-form__single {
            display: flex;
            .social{
                margin-top: 20px;
            }

            &:not(:nth-last-child(1)) {
                margin-bottom: 20px;
            }
            &__img {
                width: 20px;
                margin-right: 20px;
                filter:invert(0%) sepia(3%) saturate(23%) hue-rotate(323deg) brightness(7%) contrast(101%);
            }
            a {
                color: ${text};
                display: flex;
                font-weight: 300;
            }
        }
    }
    .ask{
        .modal-dialog{
            min-width: 100%;
            height: 100vh;
            margin: 0;
            background-color: #F1F0EE;

            .shadow-right{
                position: absolute;
                right: 0;
                font-size: 200px;
                color: rgba(0, 0, 0, 0.05);
                font-weight:600;
                top: 50%;
                right: -45px;
            }
            .shadow-bottom{
                position: absolute;
                right: 0;
                font-size: 200px;
                color: rgba(0, 0, 0, 0.05);
                font-weight:600;
                bottom: -80px;
                right: 10%;
            }
        }
        .close-modal{
            position: fixed;
            top: 20px;
            right: 50px;
            cursor: pointer;
            z-index: 9;
            .popup-one__inner {
                position: relative;
                width: 65%;
                &__close {
                    top: 30px;
                    right: 30px;
                    position: absolute;
                    width: 65px;
                    z-index: 9;
                    cursor: pointer;
                    p {
                        font-size: 16px;
                        line-height: 20px;
                        font-weight: 500;
                        color: #191D1C;
                    }
                    .spans {
                        position: absolute;
                        top: 0;
                        bottom: 0px;
                        right: 0;
                        margin: auto;
                        height: 15px;
                        width: 15px;
                        margin: auto;

                        span {
                            height: 1px;
                            width: 15px;
                            background-color: #191D1C;
                            position: absolute;
                            top: 0;
                            bottom: 0;
                            margin: auto;
                            transition: all 0.4s ease;
                            &:nth-child(1) {
                                transform: rotate(45deg);
                            }
                            &:nth-child(2) {
                                transform: rotate(-45deg);
                            }
                        }
                    }
                    &:hover {
                        span {
                            transform: none !important;
                        }
                    }
                }
                &__img {
                    position: relative;
                    padding-top: calc(300 / 830 * 100%);
                }
                .content {
                    background-color: #54595f;
                    padding: 60px 50px;
                    display: flex;
                    justify-content: space-between;
                    .text {
                        width: 45%;
                        h2 {
                            font-size: 40px;
                            line-height: 44px;
                            font-weight: 500;
                            color: #fff;
                            margin-bottom: 20px;
                        }
                        p {
                            font-weight: 300;
                            color: #fff;
                        }
                    }

                    form {
                        width: 45%;
                    }
                }
            }
        }
        .modal-content{
            min-width: 100%;
            height: 100vh;

            border:none;
            border-radius: 0;
            position: relative;
            overflow: hidden;
            .form-shadow{
                position: absolute;
                left: -20%;
                bottom: -20%;

            }
            .modal-body{
                display: flex;
                align-items: center;
            }
            .dc-btn{
                margin-top: 50px;
            }
            .ask__address__group{
                &:not(:nth-last-child(1)){
                    margin-bottom: 40px;
                }
                &:nth-child(2){
                    a{
                        margin-bottom: 5px;
                    }
                }
                h4{
                    font-size: 16px;
                    font-weight: 300;
                    color: #9192a5;
                    margin-bottom: 15px;
                }
                a{
                    font-size: 16px;
                    line-height: 19px;
                    font-weight: 600;
                    color: #041D2C;
                    display: block;
                }
                ul{
                    display: flex;
                    li{
                        a{
                            height: 30px;
                            width: 30px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            border: 1px solid ;
                            border-radius: 50%;
                        }
                        &:not(:nth-last-of-type(1)){
                            margin-right: 15px;
                        }
                    }
                }
            }
            .form-group{
                /* margin-bottom: 35px; */
            }
            .form-control{
                border:none;
                border-bottom: 1px solid rgba(4, 29, 44, 0.15);
                padding-left: 0;
                font-weight: 300;
                background-color: transparent;
                &::placeholder{
                    color: #191D1C !important;
                    font-weight: 300;
                }
                &:focus{
                    border-color: ${hover}
                }
            }
            .form-rows{
                width: 100%;
                display: flex;
                justify-content: space-between;
                gap:0 30px;
                .form-group,.select-here{
                    width: calc(50% - 15px);
                }
            }

            textarea{
                /* margin-top: 40px; */
                min-width: 100%;
                max-width:100%;
                min-height: 80px;
                max-height:150px;
                border:none;
                border-radius: 0;
                border-bottom: 1px solid rgba(4, 29, 44, 0.15);
                outline:none;
                background-color: transparent;
                color: #FFF !important;
                &::placeholder{
                    color:#191D1C !important;
                    font-weight: 300;
                }
                &:focus{
                    border-color: ${hover}
                }
            }
            //caret
            .custom__control {
                background-color: transparent;
                border: none;
                border-bottom: 1px solid rgba(4, 29, 44, 0.15) !important;
                border-radius: 0;
                box-shadow: none;
                outline: none !important;
                cursor: pointer;
                //margin-bottom: 60px;

                .custom__placeholder, .custom__single-value {
                    color: ${text};
                    font-size: 15px;
                    line-height: 20px;
                    text-transform: capitalize;
                }

                .custom__value-container {
                    padding-left: 0;
                }

                &--is-focused {

                }
            }
            .custom__menu {
                z-index: 9;
            }

            .css-t3ipsp-control:hover {
                border-color: rgba(4, 29, 44, 0.15);;
            }

            .custom__indicator-separator {
                display: none;
            }

            .custom__indicator {
                padding-right: 0;
            }

            @media(max-width:991px){
                padding-top: 120px;
                overflow: auto !important;
                .modal-body{
                    padding-left: 0;
                    padding-right: 0;
                    padding-bottom: 50px;
                }
                .close-modal{
                    right: 20px;
                    top: 40px;
                }
                .form-rows{
                    flex-wrap: wrap;
                    .form-group,.select-here{
                        min-width: 100%;
                    }
                    .select-here:nth-child(1){
                        margin-bottom: 40px;
                    }
                }
                .form-shadow{
                    left: 0%;
                    top: 0;
                    bottom: 0;
                    object-fit: cover;
                    height: 100%;
                }
                form{
                    margin-top: 60px;
                }
            }
        }
    }
    .as-career{
        .modal-content{
            background-color: #F1F0EE;
        }
        
        .modal-body{
            .row{
                align-items: unset !important;
            }
        }

        .dc-btn{
            margin-top: 0 !important;
        }

        h2{
            margin-bottom: 50px;
            font-size: 40px;
            line-height: 44px;
            font-weight: 600;
        }
        h4,h5{
            font-size: 24px;
            line-height: 32px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        form{

            .form-error {
                font-size: 12px;
                line-height: 16px;
                color: #EB1A1A;
            }

            .form-group {
                margin-bottom: 36px;
            }

            .form-flex {
                display: flex;
                gap: 30px;

                .single {
                    width: 50%;
                }
            }

            .form-label {
                margin-bottom: 0 !important;
                color: #001a95;
                font-size: 12px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px; /* 166.667% */
            }

            input {
                border-bottom: 1px solid #001a95 !important;
                color: #000 !important;
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }
                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }
                &:disabled {
                    background-color: transparent;
                    cursor: not-allowed;
                }
            }

            input:-webkit-autofill,
            input:-webkit-autofill:hover,
            input:-webkit-autofill:focus,
            input:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }

            textarea:-webkit-autofill,
            textarea:-webkit-autofill:hover,
            textarea:-webkit-autofill:focus,
            textarea:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }


            textarea {
                min-height: 150px !important;
                max-height: 150px !important;
                width: 100%;
                border: none !important;
                border-bottom: 1px solid #001a95 !important;
                background-color: transparent;
                margin-bottom: 5px;
                color: #000 !important;
                font-size: 20px !important;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                border-radius: 0 !important;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }

                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }
                &:disabled {
                    background-color: transparent;
                    cursor: not-allowed;
                }
            }

            .buttons{
                gap: 30px;
            }

            .upload{
                display: none;
            }

            .gph_upload {
                position: relative;
                cursor: pointer;
                border: none !important;
                //border-radius: 25px !important;
                overflow: hidden !important;
                padding: 8px 20px;
                text-indent: 0 !important;
                height: 44px !important;
                max-width: 175px !important;
                &.hide {
                    &:before {
                        opacity: 0;
                    }
                }

                &:after {
                    position: absolute;
                    left: 0;
                    right: 0;
                    bottom: 0;
                    top: 0;
                    content: attr(text);
                    border: 1px dashed #137EC3;
                    border-style: dashed;
                    background: #ffffff;
                    z-index: 1;
                    color: #001A94;
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 150% */
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    transition: 0.7s all ease;
                    //padding-left: 20px;
                }


                @media (min-width: 1024px) and (max-width: 1280px) {
                    &:after {
                        //padding-left: 20px;
                    }
                }


                &:hover {
                    &:after {
                        border: 1px #001A94;
                        background: #001A94;
                        color: #ffffff;
                    }
                }
            }
            
            @media(max-width: 767px){
                .form-flex{
                    flex-direction: column;
                    gap: 0;
                    .single{
                        width: 100%;
                    }
                }

                .form-group{
                    margin-bottom: 20px;
                }

                .form-label{
                    color: #000;
                    font-size: 12px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 20px; /* 166.667% */
                }

                input{
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }

                textarea{
                    min-height: 170px;
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }

                .buttons{
                    gap: 20px;
                    flex-direction: column !important;
                }
            }
        }
        .modal-content{
            overflow: scroll;
            padding-top: 100px;
            padding-bottom: 100px;
            .form-control,textarea{
                color: #000 !important;
            }
        }
        ul {
            margin-top:40px;
        }
        li {
            position: relative;
            padding-left: 20px;

            &:not(:nth-last-child(1)) {
                margin-bottom: 24px;
                border-bottom: 1px solid rgba(149, 145, 133, 0.2);
                padding-bottom: 20px;
            }
            &:after {
                content: "";
                position: absolute;
                height: 8px;
                width: 8px;
                left: 0;
                top: 7px;
                background-color: #959185;
                border-radius: 50%;
            }
        }

        @media(max-width:768px){
            .close-modal .popup-one__inner__close{
                right: 0;
                top: 0;
                background-color: #F1F0EE;
            }
            h2{
                font-size: 28px;
                line-height: 34px;
                margin-bottom: 20px;
            }
            .btn-group{
                display: flex;
                flex-wrap: wrap;
                .btn-group__files{
                    margin-bottom: 50px;
                }
            }
        }
    }


    .cursor{
        width: 70px !important;
        height: 70px !important;
        left: 0 !important;
        top: 0 !important;
        &:before{
            top: -35px !important;
            left: -35px !important;
            width: 70px !important;
            height: 70px !important;
            backdrop-filter: blur(10px);
            background-color: rgba(0,0,0,0.6) !important;
            transform: scale(0);
        }
    }

    .cursor-inner-text{
        //color: #0A0E12 !important;
        top: -35px !important;
        left: -35px !important;
    }


    .lg-outer{
        z-index: 9999!important;
    }

    .grecaptcha-badge{
        opacity: 0 !important;
    }
`;