'use client';
import styled from "styled-components";
import SubTitle from "../Title";
import {Container, Row, Col} from "react-bootstrap";
import {
    LightgalleryProvider,
    LightgalleryItem,
} from "react-lightgallery";
import "lightgallery.js/dist/css/lightgallery.css";
import {useState, useEffect, useRef} from "react";
import { gsap } from "gsap";
import Masonry, {ResponsiveMasonry} from "react-responsive-masonry";


const Gallery = ({data}) => {

    const limitedData = data?.slice(0, 5) || [];
    const [selectedFilter, setSelectedFilter] = useState(limitedData && limitedData.length > 0 ? limitedData[0] : ''); // Default filter
    const imageRefs = useRef([]); // Create a ref to store all images for animation

    const PhotoItem = ({image, thumb, group, index}) => (
        <LightgalleryItem group={group} src={image} thumb={thumb}>
            <img src={image} alt='' ref={el => imageRefs.current[index] = el} />
        </LightgalleryItem>
    );

    console.log('gallery',selectedFilter)
    const filteredData = selectedFilter?.sections?.filter(f=>f?.section_data?.template === 'gallery')?.[0]?.images?.list?.slice(0, 8);

    useEffect(() => {
        if (filteredData?.length > 0) {
            // Animate images when the component mounts or the filter changes
            gsap.fromTo(imageRefs.current,
                { opacity: 0, y: 50 },
                { opacity: 1, y: 0, duration: 0.5, stagger: 0.2, ease: "power2.out" }
            );
        }
    }, [filteredData]); // Trigger animation when filteredData changes

    return (
        <StyledGallery className='pt-150 pb-150'>
            <Container className=''>
                <ul>
                    {limitedData && limitedData?.length > 0 && limitedData.map((option, index) => (
                        <li
                            key={index}
                            className={selectedFilter === option ? 'active' : ''}
                            onClick={() => setSelectedFilter(option)}
                        >
                            <p>{option?.page_data?.business_type}</p>
                        </li>
                    ))}
                </ul>
                <LightgalleryProvider
                    lightgallerySettings={{
                        download: false,
                        thumbnail: false,
                        fullScreen: false,
                        share: false
                    }}
                >
                    <Row>
                        {/*{filteredData && filteredData?.length > 0 &&*/}
                        {/*    filteredData.map((item, index) => (*/}
                        {/*        <Col key={index} sm={3}>*/}
                        {/*            <div className="gallery-single">*/}
                        {/*                <PhotoItem image={item.full_path} group="group1" index={index}/>*/}
                        {/*            </div>*/}
                        {/*        </Col>*/}
                        {/*    ))}*/}

                        <Col>
                            <ResponsiveMasonry columnsCountBreakPoints={{350: 2, 750: 2, 900: 4}}>
                                <Masonry gutter={'30px'} children={'2'} className={'masonry'} >
                                    {filteredData && filteredData?.length > 0 &&
                                        filteredData.map((item, index) => (
                                            <div className={'wrapper'} key={index}>
                                                <PhotoItem
                                                    image={item.full_path} group="group1" index={index}/>
                                            </div>
                                        ))}
                                </Masonry>
                            </ResponsiveMasonry>
                        </Col>
                    </Row>
                </LightgalleryProvider>
            </Container>
        </StyledGallery>
    );
};

const StyledGallery = styled.section`
    position: relative;
    background-color: #222222;

    ul {
        display: flex;
        margin-bottom: 40px;
        margin-left: -8px;
        margin-right: -8px;
        li {
            display: flex;
            flex: 1;
            align-items: center;
            justify-content: center;
            padding-top: 15px;
            padding-bottom: 15px;
            border-right: 1px solid rgba(255, 255, 255, 0.10);
            border-bottom: 1px solid rgba(255, 255, 255, 0.60);
            cursor: pointer;
            position: relative;
            overflow: hidden;
            padding-left: 15px;

            p{
                color: #FFF;
                text-align: center;
                font-size: 16px;
                font-style: normal;
                font-weight: 600;
                line-height: 24px; /* 120% */
                position: relative;
                z-index: 22;
            }
            &:after {
                content: '';
                position: absolute;
                bottom: 0;
                left: 0;
                width: 100%;
                height: 0%;
                background-color: #ffffff;
                transition: height 0.2s ease-in-out;
                z-index: 1;
            }
            &:last-child{
                border-right: 0;
            }

            &.active {
                p{
                    color: #29253D !important;
                }

                &:after {
                    height: 100%;
                    transition: height 0.2s ease-in-out;
                }
            }

            &:hover {
                p{
                    color: #29253D !important;
                }

                &:after {
                    height: 100%;
                    transition: height 0.2s ease-in-out;
                }
            }
        }
    }

    .masonry {
        .wrapper {
            position: relative;
            overflow: hidden;
            max-height: 440px;
            img {
                object-fit: cover;
                overflow: hidden;
                transform: scale(1);
                transition: 0.5s ease transform;

                &:hover {
                    transform: scale(1.1);
                    transition: 0.5s ease transform;
                }
            }
        }
    }


    @media (max-width: 767px) {
        ul{
            display: flex;
            flex-wrap: wrap;
            li{
                flex: 0 0 calc(50%);
                &:nth-last-child(-n + 1):nth-child(odd) {
                    flex-basis: 100%;
                }
                &:nth-child(even){
                    border-right: 0 !important;
                }
            }
        }
        .masonry {
            gap: 15px !important;
            div {
                gap: 15px !important;
            }
        }
    }
`;

export default Gallery;
