"use client";
import styled from "styled-components";
import { Container, Row, Col } from "react-bootstrap";
import { text } from "@/styles/globalStyleVars";
import Button from "@/components/Button";
import {useEffect, useState} from "react";
import {Swiper, SwiperSlide} from "swiper/react";
import "swiper/css";
import "swiper/css/effect-fade";
import "swiper/css/navigation";
import "swiper/css/pagination";
import 'swiper/css/scrollbar';
import {Autoplay, Navigation, Pagination, EffectFade} from "swiper";
import reactHtmlParser from "react-html-parser";

export default function Video({ data }) {

    const [offset, setOffset] = useState(90)


    useEffect(() => {
        const updateOffset = () => setOffset(document.querySelector('.container')?.offsetLeft);

        window.addEventListener('load', updateOffset);
        window.addEventListener('resize', updateOffset);

        updateOffset(); // Initial calculation

        return () => {
            window.removeEventListener('load', updateOffset);
            window.removeEventListener('resize', updateOffset);
        }
    }, []);


    const handleScroll = () => {
        window.scrollBy({
            top: window.innerHeight, // Scroll by the full viewport height
            behavior: 'smooth', // Smooth scrolling
        });
    };

    return (
        <StyleComponent className="video" offset={offset}>
            <div className={'scroll-down'} onClick={handleScroll}>
                <svg width="62" height="62" viewBox="0 0 62 62" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g>
                        <circle cx="30.5713" cy="30.5221" r="30" stroke="white"/>
                        <path d="M30 18.5222V42.5222" stroke="white" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M22 34.5222L30 42.5222L38 34.5222" stroke="white" stroke-linecap="round"
                              stroke-linejoin="round"/>
                    </g>
                </svg>

            </div>
            <Container>
                <Row>
                    <Col md={6}>
                        <h1 className={'split-title'}>{reactHtmlParser(data?.section_data?.subtitle)}</h1>
                    </Col>
                </Row>
            </Container>
            <div className={'slider'} data-speed={1.2}>
                <div className={'slider__inner'}>
                    {
                        data?.posts &&
                        <Swiper
                            spaceBetween={30}
                            modules={[Autoplay, Pagination, Navigation]}
                            autoplay={{ delay: 8000, disableOnInteraction: false, pauseOnMouseEnter: true }}
                            pagination={{
                                clickable: true,
                                el: '.swiper-pagination',
                                renderBullet: function (index, className) {
                                    return '<span class="' + className + '"></span>';
                                },
                            }}
                            className="custom-slider"
                        >
                            {
                                data?.posts?.list?.length > 0 &&
                                data?.posts?.list?.map((e,i)=>{
                                    return(
                                        <SwiperSlide key={i}>
                                            <p>
                                                {reactHtmlParser(e?.data?.description)}
                                            </p>
                                        </SwiperSlide>
                                    );
                                })
                            }
                        </Swiper>
                    }

                    <div className="swiper-pagination"></div>
                </div>
                <Button text={data?.section_data?.button_label} margin={'120px 0 0 0'} color={'#001A94'} src={`/${data?.section_data?.button_url}`}/>
            </div>
            <div className="video__inner">
                <video
                    loop
                    autoPlay
                    playsInline
                    muted
                    preload="metadata" // Add this to improve performance
                    poster={data?.images?.list?.filter(f => f?.video != 'on')[0]?.full_path}
                >
                    <source src={data?.images?.list?.filter(f => f?.video === 'on')[0]?.full_path} type="video/mp4"/>
                </video>
            </div>
        </StyleComponent>
    );
}
const StyleComponent = styled.section`
    position: relative;
    max-height: 100vh;

    &::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.15);
        z-index: 1;
    }

    .scroll-down {
        cursor: pointer;
        position: absolute;
        bottom: 20px;
        left: ${props => props.offset ? props.offset + 15 + 'px' : '140px'};
        z-index: 3;
        

        svg {
            height: 60px;
            width: 60px;
            g {
                path {
                    color: #ffffff !important;
                    animation: moveAndFade 2.5s infinite;

                    @keyframes moveAndFade {
                        0% {
                            transform: translateY(0);
                            opacity: 1;
                        }
                        50% {
                            transform: translateY(15px);
                            opacity: 0.5;
                        }
                        100% {
                            transform: translateY(30px);
                            opacity: 0;
                        }
                    }
                }
            }
        }
    }


    .container {
        position: absolute;
        top: 50%;
        left: calc(50% + 15px);
        transform: translate(-50%, -50%);
        z-index: 2;
    }
    .col-md-6{
        padding-left: 0;
        padding-right: 0;
    }
    h1 {
        color: #FFF;
        font-size: 80px;
        font-style: normal;
        font-weight: 700;
        line-height: 119%; /* 80px */
    }
    .video__inner {
        padding-top: 100%;
        height: 100vh;
        position: relative;
        background-color: ${text};
        video {
            position: absolute;
            //height: 100%;
            width: 100%;
            object-fit: cover;
            inset: 0;
        }
    }

    .slider{
        position: absolute;
        max-width: 350px;
        right: ${props => props.offset ? props.offset + 15 + 'px' : '140px'};
        z-index: 3;
        bottom: -10%;
        padding: 40px;
        background: radial-gradient(252% 110.16% at 24.49% 80.21%, #00167D 0%, #001A94 100%);
        backdrop-filter: blur(15px);
        &__inner{
            p{
                color: #FFF;
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }
            .swiper-pagination {
                position: absolute;
                bottom: 40%; /* Adjust as needed */
                left: 40px;
                display: flex;
            }

            .swiper-pagination-bullet {
                //width: 16px;
                //height: 16px;
                //background: radial-gradient(circle at 18% 60%, #f6f6f6 0%, #f8f8f8 100%);
                //opacity: 1;
                //margin: 0 5px; /* Adjust spacing between bullets */
                //position: relative;

                height: 5px;
                width: 10px !important;
                border-radius: 5px !important;
                background-color: #ffffff !important;
                transition: width 0.3s ease-in-out;
            }

            .swiper-pagination-bullet-active {
                //border: 1px solid rgba(255, 255, 255, 0.1) !important;
                //&::after {
                //    content: '';
                //    position: absolute;
                //    top: 50%;
                //    left: 50%;
                //    transform: translate(-50%, -50%);
                //    width: 10px;
                //    height: 10px;
                //    background: #00167D;
                //    border-radius: 50%;
                //}
                height: 5px;
                width: 15px !important;
                border-radius: 5px !important;
                background-color: #ffffff !important;
                transition: width 0.3s ease-in-out;
            }
        }
    }

    @media(max-width: 767px){
        height: calc(100svh) !important;
        .container{
            top: 40% !important;
        }

        .scroll-down{
            display: none;
        }
        .col-md-6{
            padding-left: 15px;
            padding-right: 15px;
        }
        h1{
            font-size: 42px;
            line-height: 42px;
        }

        .slider{
            max-width: 100%;
            bottom: -50px;
            left: 20px;
            right: 20px;
            padding: 30px;

            .swiper-pagination{
                left: 30px;
            }
        }
        
        .video__inner{
            video{
                height: 100% !important;
            }
        }
    }
    @media(max-width: 991px){
        height: calc(100svh) !important;
        .container{
            top: 50%;
        }

        .scroll-down{
            display: none;
        }
        .col-md-6{
            padding-left: 15px;
            padding-right: 15px;
        }

        .slider{
            max-width: 100%;
            bottom: -100px;
            left: 20px;
            right: 20px;
            padding: 50px 30px;

            .swiper-pagination{
                left: 30px;
            }
        }
    }
`;
