'use client';
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import Link from 'next/link'

const MyComponent = ({data}) => {
    return (
        <>
            {
                data?.posts?.list?.length > 0 &&
                <StyledComponent>
                    <Container>
                        <div className={'social'}>
                            {
                                data?.posts?.list && data?.posts?.list?.length > 0 &&
                                data?.posts?.list?.map((e,i)=>{
                                    return (
                                        <div className={'social__single'}>
                                            <a href={e?.data?.short_desc} target={'_blank'}>
                                                <img src={e?.images?.[0]?.full_path}/>
                                                <p>{e?.data?.title}</p>
                                            </a>
                                        </div>
                                    );
                                })
                            }
                        </div>
                    </Container>
                </StyledComponent>
            }
        </>
    );
};

const StyledComponent = styled.section`
    background-color: #001A94;
    padding-top: 80px;
    padding-bottom: 80px;

    .social {
        display: flex;
        gap: 88px;
        align-items: center;
        justify-content: center;

        &__single {
            a{
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 20px;

                p {
                    color: #FFF;
                    font-feature-settings: 'liga' off;
                    font-size: 24px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 40px; /* 166.667% */
                }
            }
        }
    }


    @media (max-width: 767px) {
        .social {
            flex-wrap: wrap;
            gap: 20px;
            justify-content: flex-start;

            &__single {
                width: 47%;
                a {
                    justify-content: flex-start;
                    img{
                        height: 20px;
                        width: 20px;
                    }
                    p{
                        font-size: 20px;
                        line-height: 24px;
                    }
                }
            }
        }
    }

    @media (max-width: 991px) {
        .social {
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;

            &__single {
                width: 48%;
                a {
                    justify-content: center;
                    img{
                        height: 20px;
                        width: 20px;
                    }
                    p{
                        font-size: 20px;
                        line-height: 24px;
                    }
                }
            }
        }
    }
`;

export default MyComponent;
