'use client';
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import {Img} from "@/components/SmallImageParallax";
import reactHtmlParser from "react-html-parser";
import Button from "@/components/Button";


const MyComponent = ({data}) => {
    return (
        <StyledComponent className="pt-120 pb-200" id={'overview'}>
            <svg className={'bg'} xmlns="http://www.w3.org/2000/svg" width="910.794" height="552" viewBox="0 0 910.794 552" data-speed={"clamp(1.1)"}>
                <path id="bg"
                      d="M867.239,422.942h1v-2.985l-1.8,2.382Zm-11.525,15.269-.8-.6-.005.006,0,.006Zm11.525-14.981h-1v.217l.09.2Zm39.182,85.856-.909.415,0,.005ZM879.915,550l-.015,1h0ZM318.97,541.354l-.028,1h.013Zm-24.2-13.829-.852.524,0,0ZM121.328,245.756l.852-.525-1.852-3.008v3.533Zm0,285.226v1h1v-1Zm-121,0h-1v1h1ZM.323,0V-1h-1V0ZM132.276,14.982l.876-.483,0-.007ZM360.458,428.416l.883-.469,0-.007,0-.007ZM385.235,443.4l.014-1h-.014Zm447.143,6.339-.015,1h.015ZM707.744,111.193l.89-.457h0Zm-114.777.924-.884.467h0ZM542.452,16.448l.885-.467h0Zm116.188-.924-.89.457h0ZM444.784,159.35l-.884.467h0ZM495.3,255.019l.884-.467h0Zm114.776-.924.89-.457h0Zm-49.1-95.668.89-.457h0ZM386.963,378l-.9.431,0,.008ZM238.3,66.265l-.9.425,0,.005ZM488.953,14.694l.879-.477-.284-.523h-.6Zm53.012,97.668v1h1.681l-.8-1.477ZM387.828,133.394l.882-.47-.005-.009Zm84.991,159.612.884-.468v0Zm227.605,7.779v1h1.656l-.771-1.466Zm-75.2-142.9v-1h-1.656l.771,1.466ZM736.438,176.9l.881-.471h0Zm90.177,168.543-.881.472,0,.005Zm39.825,76.9-11.524,15.27,1.6,1.2,11.524-15.27Zm1.8.891v-.288h-2v.288Zm39.092,85.441-39.183-85.856-1.819.83L905.512,509.5ZM879.9,551a29.839,29.839,0,0,0,27.427-42.331l-1.815.84A27.838,27.838,0,0,1,879.929,549Zm-560.947-8.643L879.9,551l.031-2-560.945-8.643Zm-25.036-14.3a30.221,30.221,0,0,0,25.023,14.3l.057-2A28.217,28.217,0,0,1,295.619,527ZM120.477,246.28l173.44,281.769,1.7-1.048L122.18,245.231Zm1.851,284.7V245.756h-2V530.982Zm-122,1h121v-2H.323ZM-.677,0V530.982h2V0Zm107.6-1H.323V1h106.6Zm26.225,15.491A29.971,29.971,0,0,0,106.923-1V1A27.973,27.973,0,0,1,131.4,15.472ZM361.333,427.933,133.152,14.5l-1.751.966L359.582,428.9Zm23.9,14.464a27.074,27.074,0,0,1-23.894-14.45l-1.767.938A29.076,29.076,0,0,0,385.235,444.4Zm447.157,6.339L385.249,442.4l-.028,2,447.142,6.339Zm22.515-11.115a27.533,27.533,0,0,1-22.529,11.115v2A29.534,29.534,0,0,0,856.522,438.8ZM706.855,113.65a2,2,0,0,0,1.779-2.914l-1.779.914h0Zm-113,0h113v-2h-113Zm-1.769-1.066a2,2,0,0,0,1.769,1.066v-2h0ZM541.568,16.915l50.515,95.669,1.769-.934L543.337,15.981Zm1.769-2.934a2,2,0,0,0-1.769,2.934l1.769-.934h0Zm114.413,0H543.337v2H657.75Zm1.78,1.087a2,2,0,0,0-1.78-1.087v2h0Zm49.1,95.668-49.1-95.668-1.78.913,49.1,95.669ZM445.669,158.883h0v-2a2,2,0,0,0-1.769,2.934Zm50.515,95.669-50.515-95.669-1.769.934,50.515,95.669Zm0,0h0l-1.769.933a2,2,0,0,0,1.769,1.067Zm113,0h-113v2h113Zm0,0h0v2a2,2,0,0,0,1.779-2.914Zm-49.1-95.669,49.1,95.669,1.779-.914-49.1-95.668Zm0,0h0l1.779-.913a2,2,0,0,0-1.779-1.087Zm-114.414,0H560.083v-2H445.669Zm-59.6,219.553a37.428,37.428,0,0,0,33.454,21.017v-2a35.428,35.428,0,0,1-31.657-19.895ZM237.4,66.7,386.061,378.428l1.8-.861L239.2,65.835Zm33.459-53c-27.249,0-45,28.43-33.461,53l1.81-.851c-10.929-23.259,5.888-50.146,31.651-50.146Zm218.1,0h-218.1v2h218.1Zm53.891,98.191L489.832,14.217l-1.758.954,53.012,97.668ZM400.5,113.362H541.965v-2H400.5Zm-11.8,19.553a13.246,13.246,0,0,1,11.8-19.553v-2a15.245,15.245,0,0,0-13.554,22.511Zm85,159.621L388.71,132.924l-1.765.94,84.992,159.612Zm11.794,7.249a13.367,13.367,0,0,1-11.793-7.247l-1.768.936a15.368,15.368,0,0,0,13.561,8.311Zm214.928,0H485.5v2H700.424ZM624.343,158.349l75.2,142.9,1.77-.931-75.2-142.9Zm80.4-1.466H625.228v2h79.518Zm32.573,19.543a36.834,36.834,0,0,0-32.573-19.543v2a34.832,34.832,0,0,1,30.81,18.488ZM827.5,344.969,737.319,176.427l-1.763.943,90.178,168.543Zm-32.574,54.484c27.832,0,45.9-29.9,32.571-54.488l-1.758.953c12.6,23.239-4.479,51.535-30.813,51.535Zm-375.4,0h375.4v-2h-375.4Z"
                      transform="translate(0.677 1)" fill="#fff"/>
            </svg>
            <Container>
                <Row>
                    <div className={'title'}>
                        <h3>
                            {reactHtmlParser(data?.section_data?.subtitle)}
                        </h3>
                    </div>
                    <Col md={6} className={'overview__img'}>
                        <div className="overview__img__wrapper">
                            <Img src={data?.images?.list?.[0]?.full_path}/>
                        </div>
                    </Col>
                    <Col md={6} className={'overview__content'}>
                        <h5>
                            {reactHtmlParser(data?.section_data?.short_desc)}
                        </h5>
                        {reactHtmlParser(data?.section_data?.description)}
                        {
                            data?.files?.list?.[0]?.full_path &&
                            <div>
                                <Button
                                    text={'Download Brochure'}
                                    src={data?.files?.list?.[0]?.full_path}
                                    background={'#001A94'}
                                    color={'#ffffff'}
                                    margin={'40px 0 0 0'}
                                    svgColor={'#ffffff'}
                                    target={'_blank'}
                                />
                            </div>
                        }
                    </Col>
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #222222;
    position: relative;
    overflow: hidden;

    .bg {
        position: absolute;
        bottom: -20px;
        right: 0;
        opacity: 0.1;
    }

    .title {
        margin-bottom: 60px;

        h3 {
            color: #FFF;
            font-size: 40px;
            font-style: normal;
            font-weight: 400;
            line-height: 60px;

            span {
                display: inline-block;
                color: #FFF;
                font-size: 14px;
                font-style: normal;
                font-weight: 700;
                line-height: 20px;
                position: relative;
                width: 370px !important;
                margin-right: 10px;

                &:after {
                    content: '';
                    position: absolute;
                    top: -10px;
                    left: 0;
                    height: 1px;
                    width: 100%;
                    background-color: #ffffff;
                    z-index: 2;
                }
            }
        }
    }

    .overview__img {
        padding: 0;

        &__wrapper {
            position: relative;
            overflow: hidden;
            //padding-top: calc(500 / 500 * 100%);
            padding-top: 100%;
            margin-right: 100px;
        }
    }

    .overview__content {
        padding: 0;

        h5 {
            color: #FFF;
            font-size: 24px;
            font-style: normal;
            font-weight: 400;
            line-height: 32px; /* 133.333% */
            margin-bottom: 40px;
        }

        p {
            color: #FFF;
            font-size: 16px;
            font-style: normal;
            font-weight: 400;
            line-height: 24px; /* 150% */
        }
        
        ul, ol{
            padding-left: 0;
            display: flex;
            flex-direction: column;
            li{
                color: #FFF;
                padding-bottom: 10px;
                margin-bottom: 10px;
                border-bottom: 1px solid #f8f8f8;
                position: relative;
                padding-left: 20px;
                
                &::after{
                    content: '';
                    position: absolute;
                    top: 40%;
                    left: 0px;
                    width: 5px;
                    height: 5px;
                    border-radius: 50%;
                    background-color: white;
                    transform: translateY(-50%);
                }
            }
        }
    }
    
    
    @media(max-width: 767px){
        .row{
            margin-right: 0px;
            margin-left: 0px;
        }
        
        .title{
            margin-bottom: 40px;
            h3{
                font-size: 30px;
                line-height: 100%;
                
                span{
                    margin-bottom: 10px;
                }
            }
        }
        
        .overview__img{
            margin-bottom: 30px;
            &__wrapper{
                margin-right: 0;
            }
        }
        
        .overview__content{
            h5{
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 28px; /* 140% */
                margin-bottom: 30px;
            }
            
            p{
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }
        }
    }


    @media(max-width: 991px){
        .row{
            margin-right: 0px;
            margin-left: 0px;
        }

        .title{
            margin-bottom: 40px;
            h3{
                font-size: 30px;
                line-height: 100%;

                span{
                    margin-bottom: 10px;
                }
            }
        }

        .overview__img{
            margin-bottom: 30px;
            max-width: 100% !important;
            flex: 0 0 100% !important;
            &__wrapper{
                margin-right: 0;
            }
        }

        .overview__content{
            max-width: 100% !important;
            flex: 0 0 100% !important;
            h5{
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 28px; /* 140% */
                margin-bottom: 30px;
            }

            p{
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }
        }
    }
`;

export default MyComponent;
