"use client"
import React, { useEffect } from 'react';
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import Title from "@/components/Title";
import ImageReveal from "@/components/ImageReveal";
import Button from "@/components/Button";
import reactHtmlParser from "react-html-parser";
import {Img} from "@/components/SmallImageParallax";
import Link from "next/link";

const MyComponent = ({data, bgVector,img,title,description,btnText,btnLink, textColor, bgColor,overlayColor}) => {


    return (
        <StyledComponent className={'overview pt-200 pb-200'} textColor={textColor} bgColor={bgColor} overlayColor={overlayColor} >
            <Container>
                {
                    data && data?.length > 0 &&
                    data?.map((concern, index)=>{
                        return(
                            <Row>
                                <Col lg={12} >
                                    <Row className={'overview-wrapper'}>
                                        <Col lg={6}>
                                            <Link href={`/industries/${concern?.page_data?.slug}`}>
                                                <div className="overview-img reveal-img">
                                                    <Img
                                                        src={concern.images?.list?.find(f => f?.thumb === 'on')?.full_path}/>
                                                </div>
                                            </Link>
                                        </Col>
                                        <Col lg={{span: 5, offset: 1}}>
                                            <div className="overview-text " data-speed={'1.1'}>
                                                <Link href={`/industries/${concern?.page_data?.slug}`}>
                                                    <h4 className={'split-up'}>{reactHtmlParser(concern?.page_data?.title)}</h4>
                                                    <p>{reactHtmlParser(concern?.page_data?.short_desc)}</p>
                                                    <div className="bottom">
                                                        <Link href={`/industries/${concern?.page_data?.slug}`}
                                                              prefetch={true}>
                                                            <p>Explore Industry</p>
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="18"
                                                                 viewBox="0 0 17 18" fill="none">
                                                                <path d="M4.24268 13.2426L12.728 4.75727" stroke="#001A94"
                                                                      strokeWidth="1.5" strokeLinecap="round"
                                                                      strokeLinejoin="round"/>
                                                                <path d="M12.728 13.2426V4.75727H4.24275" stroke="#001A94"
                                                                      strokeWidth="1.5" strokeLinecap="round"
                                                                      strokeLinejoin="round"/>
                                                            </svg>
                                                        </Link>
                                                    </div>
                                                </Link>
                                            </div>
                                        </Col>
                                    </Row>

                                </Col>
                            </Row>
                        );
                    })
                }
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    will-change: transform;
    position: relative;
    background-color: ${(props) => props.bgColor || "#FFF"};
    

    .row {
        .overview-wrapper {
            margin-bottom: 160px;
        }
        
        &:last-child{
            .overview-wrapper {
                margin-bottom: 0px !important;
            }
        }
        &:nth-child(odd) {
            .overview-wrapper {
                &:before {
                    right: 0 !important;
                }
            }
        }

        &:nth-child(even){
            .overview-wrapper{
                flex-direction: row-reverse;
                &:before{
                    left: 0 !important;
                }
            }
        }
        
        @media (max-width: 767px){
            .overview-wrapper {
                margin-bottom: 30px;
            }
        }
        @media (max-width: 991px){
            .overview-wrapper {
                margin-bottom: 40px;
            }
        }
    }
    
    .overview-wrapper {
        position: relative;

        &:before {
            content: '';
            position: absolute;
            top: 15%;
            width: 70%;
            height: 100%;
            background-color: ${(props) => props.overlayColor || "#f3f3f3"};
        }
        
    }

    .overview-img {
        position: relative;
        padding-top: calc(600 / 750 * 100%);
        height: 100%;
    }
    
    .overview-text{
        
        margin-top: 30%;
        padding-top: 60px;
        
        h4{
            margin-bottom: 20px;
            color: #272b2e;
            
            &:hover{
                color: #272b2e;
            }
        }
    }
    
    p{
        font-size: 16px;
        font-weight: 400;
        line-height: 100%;
        color: #272b2e;
        width: 80%;
        margin-bottom: 20px;
    }

    .bottom{
        a{
            display: flex;
            align-items: center;
            gap: 10px;

            p{
                color: #001A94;
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
                max-width: max-content;
                margin-bottom: 0;
            }
            svg{
                transition: 0.3s all ease-in-out;
            }

            &:hover{
                svg{
                    transform: rotate(45deg);
                    transition: 0.3s all ease-in-out;
                }
            }
        }
    }
    
    @media(max-width: 767px){
        .overview-wrapper {
            display: flex;
            margin-bottom: 30px;
            &:before{
                display: none;
            }

            .overview-text{
                margin-top: 20px;
                padding-top: 0;
                
                
                p{
                    width: 100%;
                }
            }
        }
    }
    
    
    @media(max-width: 991px){
        .overview-wrapper {
            margin-bottom: 30px;
            display: flex;
            &:before{
                display: none;
            }

            .overview-text{
                margin-top: 20px;
                padding-top: 0;


                p{
                    width: 100%;
                }
            }
        }
    }
`;

export default MyComponent;