'use client';
import React from 'react';
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import {
    LightgalleryProvider,
    LightgalleryItem,
} from "react-lightgallery";
import "lightgallery.js/dist/css/lightgallery.css"
import reactHtmlParser from "react-html-parser";

const MyComponent = ({data}) => {

    const PhotoItem = ({image, thumb, group}) => (
        <LightgalleryItem group={group} src={image} thumb={thumb}>
            <img src={image} alt=''/>
            {/*<img src={image} alt=""/>*/}
        </LightgalleryItem>

    );
    return (
        <>
            {
                data?.images?.list?.length > 0 &&
                <StyledComponent className={"pt-120"}>
                    <Container>
                        <h2 className={'split-up'}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                        <LightgalleryProvider
                            lightgallerySettings={
                                {
                                    download: false,
                                    thumbnail: false,
                                    fullScreen: false,
                                    share: false
                                }
                            }
                        >
                            <Row>
                                {
                                    data?.images?.list && data?.images?.list?.length > 0 &&
                                    data?.images?.list?.map((e,i)=>{
                                        return(
                                            <Col key={i} sm={3}>
                                                <div className="gallery-single">
                                                    <PhotoItem image={e?.full_path} group="group1"/>
                                                </div>
                                            </Col>
                                        );
                                    })
                                }
                            </Row>
                        </LightgalleryProvider>
                    </Container>
                </StyledComponent>
            }
        </>
    );
};

const StyledComponent = styled.section`
    background-color: #F6F6F6;

    h2{
        color: #001A94;
        font-size: 60px;
        font-style: normal;
        font-weight: 700;
        line-height: 74px;
        margin-bottom: 40px;
    }

    .col-sm-3 {
        padding: 0 8px;
        margin-bottom: 17px;
    }

    .gallery-single {
        padding-top: calc(300 / 280 * 100%);
        position: relative;
        cursor: pointer;

        img {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
    }

    @media (max-width: 767px) {
        .col-sm-3 {
            flex: 0 0 50%;
            max-width: 50%;
            padding: 0 5px;
            margin-bottom: 10px;
        }

    }
`;

export default MyComponent;
