"use client";
import React from "react";
import styled from 'styled-components';
import Link from "next/link";
import {title} from "@/styles/globalStyleVars";

const Button = ({
                    onSubmit,
                    text,
                    maxLength, // New prop for max length
                    src,
                    img,
                    hoverImg,
                    fontSize,
                    fontWeight,
                    color,
                    letterSpacing,
                    lineHeight,
                    margin,
                    background,
                    borderRadius,
                    border,
                    width,
                    height,
                    hoverBackground,
                    target,
                    borderColor,
                    hoverColor,
                    svgColor,
                    onClick
                }) => {

    // Truncate text if it exceeds the maxLength
    const truncateText = (text) => {
        if (maxLength && text.length > maxLength) {
            return `${text.substring(0, maxLength)}...`;
        }
        return text;
    };

    return (
        <StyledBtn onClick={onClick} className={`dc-btn`}
                   fontSize={fontSize}
                   fontWeight={fontWeight}
                   color={color}
                   background={background}
                   lineHeight={lineHeight}
                   letterSpacing={letterSpacing}
                   margin={margin}
                   border={border}
                   img={img}
                   borderRadius={borderRadius}
                   width={width}
                   hoverImg={hoverImg}
                   hoverBackground={hoverBackground}
                   height={height}
                   borderColor={borderColor}
                   target={target}
                   hoverColor={hoverColor}
                   onSubmit={onSubmit}
        >
            {src ? (
                <Link href={src || '/'}>
                    <span>{truncateText(text)}</span>
                </Link>
            ) : (
                <a target={target || '_self'}>
                    <span>{truncateText(text)}</span>
                </a>
            )}
        </StyledBtn>
    )
};

const StyledBtn = styled.div`
    &.dc-btn {
        margin: ${props => props.margin || '0'};
        width: ${props => props.width || 'max-content'};
        height: ${props => props.height || '44'}px;
        cursor: pointer;

        a {
            display: flex;
            width: fit-content;
            height: 100%;
            align-items: center;
            justify-content: center;
            font-family: ${title};
            font-size: ${props => props.fontSize || '16'}px;
            font-weight: ${props => props.fontWeight || 400};
            margin: 0;
            line-height: ${props => props.lineHeight || '24'}px;
            letter-spacing: -0.48px;
            background-color: ${props => props.background || `#ffffff`};
            position: relative;
            overflow: hidden;
            z-index: 0;
            padding: 8px 20px;
            box-sizing: border-box;
            gap: 10px;
            border: 1px dashed #001A94;
            text-align: center;

            svg {
                transition: 0.3s all ease-in-out;
            }

            span {
                transition: color .3s ease;
                color: ${props => props.color || `#001A94`};
                position: relative;
                z-index: 2;
            }

            &:hover {
                background-color: #001A94;
                transition: 0.75s all ease-in-out;
                span {
                    color: ${props => props.hoverColor || `#ffffff`};
                }

                svg {
                    transform: rotate(45deg);
                    transition: 0.3s all ease-in-out;
                }
            }

            &:focus {
                color: #222222;
            }
        }
    }
`;

export default Button;
