"use client";
import React, {useEffect, useRef, useState} from "react";
import styled from "styled-components";
import { Container, Row, Col, Modal, Form } from "react-bootstrap";
import Link from "next/link";
import Button from "../Button";
import { useForm } from "react-hook-form";
import { toast } from "react-toastify";
import axios from "axios";
import Title from "@/components/Title";
import UploadButton from "@/components/career/UploadButton";
import reactHtmlParser from "react-html-parser";

const JobList = ({ data }) => {
    const [show, setShow] = useState(false);
    const [selectedJob, setSelectedJob] = useState(null);
    const [isSubmit, setIsSubmitting] = useState(false);
    const {register, control, handleSubmit, formState: {errors, isSubmitSuccessful, isSubmitting}, reset} = useForm({
        mode: "all",
    })

    const handleClose = () => {
        setSelectedJob(null);
        setShow(false)
    };
    const handleShow = (job) => {
        setSelectedJob(job);
        setShow(true);
    };

    //--- form submit
    const success = (msg) =>
        toast.success(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const error = (msg) =>
        toast.error(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });


    console.log('job', data)

    // Get the current URL for sharing
    const [shareUrl, setShareUrl] = useState("");

    useEffect(() => {
        // Set the share URL once the component mounts
        if (typeof window !== "undefined") {
            setShareUrl(window.location.href);
        }
    }, []);

    // const [file, setFile] = useState("");
    // const handleInput = () => {
    //   let file = document.querySelector("#input-file").files[0];
    //   setFile(file && file?.name);
    // };


    const [uploadText, setUploadText] = useState('Upload resume');
    const [cv, setCv] = useState(null);
    const [cvError, setCvError] = useState(null);
    const cvRef = useRef();

    const handleUploadClick = () => {
        cvRef.current.click();
    };

    const handleUpload = (event) => {
        const selectedFile = event.target.files[0];

        if (selectedFile) {
            const fileName = selectedFile.name;
            const fileSize = selectedFile.size;
            const fileType = selectedFile.type;

            if (fileType !== 'application/pdf') {
                setCvError('Please upload a PDF file.');
                setUploadText('Upload resume');
                setCv(null);
            } else if (fileSize > 2 * 1024 * 1024) { // 2MB limit
                setCvError('File size should be less than 2MB.');
                setUploadText('Upload resume');
                setCv(null);
            } else {
                setCv(selectedFile);
                setUploadText(fileName);
                setCvError(null);
                document.querySelector('.gph_upload').classList.add('hide');
            }
        }
    };




    const onSubmit = async (data) => {
        setIsSubmitting(true);
        try {
            const formData = new FormData();
            formData.append('first_name', data?.first_name);
            formData.append('last_name', data?.last_name);
            formData.append('email', data?.email);
            formData.append('phone', data?.phone);
            formData.append('position', selectedJob?.data?.title);
            formData.append('cover', data?.cover);
            formData.append("file", cv);
            formData.append('form_id', 'career-form');

            const response = await axios.post('https://project.bestinbd.com/2407NGI/api/post-req-data/form-submit', formData);

            if (response.status === 200) {
                success('Form submitted successfully');
                reset(); // Reset form fields
            } else {
                error('Failed to submit form. Please try again later.');
            }
        } catch (err) {
            error('Failed to submit form. Please try again later.');
        } finally {
            setIsSubmitting(false)
        }
    };
    const onError = (errors) => {
        // setToastShown(false); // Reset toast shown state on new submission attempt
        const firstError = Object.values(errors)[0];
        error(firstError.message);
    };

    return (
        <StyledComponent className="job-list pt-120 pb-120">
            <Container>
                <Row className="job-list__title">
                    <Col>
                        <Row>
                            <Col md={6} className="fade-up">
                                <Title text={'Apply Now'}/>
                            </Col>
                        </Row>
                    </Col>
                </Row>
                <Row>
                    {
                        data?.length > 0 ?
                            <div className="job-list__item">
                                {
                                    data && data?.length > 0 &&
                                    data?.map((e, i) => {
                                        return (
                                            <div className="job-list__item__single" key={i}>
                                                <Col md={4}>
                                                    <h4>{reactHtmlParser(e?.data?.title)}</h4>
                                                </Col>
                                                <Col md={5}>
                                                    <p>
                                                        {reactHtmlParser(e?.data?.overview)}
                                                    </p>
                                                </Col>
                                                <Col md={3}>
                                                    <div onClick={() => handleShow(e)}>
                                                        <Button
                                                            text={'Apply Now'}
                                                            background={'#001A94'}
                                                            color={'#ffffff'}
                                                            svgColor={'#ffffff'}
                                                        />
                                                    </div>
                                                </Col>
                                            </div>
                                        );
                                    })
                                }
                            </div>
                            :
                            <h4>Not hiring at this moment</h4>
                    }
                </Row>
            </Container>
            {/* modal  */}
            <Modal className="ask as-career" show={show} onHide={handleClose}>
                <div className="close-modal" onClick={handleClose}>
                    <div className="popup-one__inner__close">
                        <p>Close</p>
                        <div className="spans">
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
                <Modal.Body>
                    <Container>
                        <Row>
                            <Col lg={5}>
                                <h2>{reactHtmlParser(selectedJob?.data?.title)}</h2>
                            </Col>
                        </Row>
                        <Row>
                            <Col lg={5} className="ask__address">
                                {reactHtmlParser(selectedJob?.data?.description)}
                            </Col>
                            <Col lg={{span: 6, offset: 1}}>
                                <Form>
                                    <div className="form-flex">
                                        <div className="single">
                                            <Form.Group className={'form-group'}>
                                                <Form.Label htmlFor="firstname">First Name*</Form.Label>
                                                <Form.Control
                                                    {...register("first_name", {
                                                        required: {
                                                            value: true,
                                                            message: "Please enter first name"
                                                        },
                                                    })}
                                                    type="text"
                                                    placeholder="John"
                                                    onFocus={(e) => (e.target.placeholder = "")}
                                                    onBlur={(e) => (e.target.placeholder = "John")}
                                                    disabled={isSubmitting}  // Disable the field
                                                />
                                                <p className={'form-error'}>{errors.first_name?.message}</p>
                                            </Form.Group>
                                        </div>
                                        <div className="single">
                                            <Form.Group className={'form-group'}>
                                                <Form.Label htmlFor="secondname">Last Name *</Form.Label>
                                                <Form.Control
                                                    {...register("last_name", {
                                                        required: {
                                                            value: true,
                                                            message: "Please enter last name"
                                                        },
                                                    })}
                                                    type="text"
                                                    placeholder="Doe"
                                                    onFocus={(e) => (e.target.placeholder = "")}
                                                    onBlur={(e) => (e.target.placeholder = "Doe")}
                                                    disabled={isSubmitting}  // Disable the field
                                                />
                                                <p className={'form-error'}>{errors.last_name?.message}</p>
                                            </Form.Group>
                                        </div>
                                    </div>

                                    <div className="form-flex">
                                        <div className="single">
                                            <Form.Group className={'form-group'}>
                                                <Form.Label htmlFor="email">Email *</Form.Label>
                                                <Form.Control {...register("email", {
                                                    required: 'Please enter your email',
                                                    pattern: {
                                                        value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                                        message: 'Please enter a valid email address',
                                                    },
                                                })}
                                                              type="email"
                                                              placeholder="your@gmail.com"
                                                              onFocus={(e) => (e.target.placeholder = "")}
                                                              onBlur={(e) => (e.target.placeholder = "your@gmail.com")}
                                                              disabled={isSubmitting}
                                                />
                                                <p className={'form-error'}>{errors.email?.message}</p>
                                            </Form.Group>
                                        </div>
                                        <div className="single">
                                            <Form.Group className={'form-group'}>
                                                <Form.Label htmlFor="phone">Phone Number *</Form.Label>
                                                <Form.Control {...register("phone", {
                                                    required: 'Please enter your phone number',
                                                    pattern: {
                                                        value: /^01[0-9]{9}$/,
                                                        message: 'Please enter a valid 11 digit phone number',
                                                    },
                                                })}
                                                              type="number"
                                                              placeholder="01........."
                                                              onFocus={(e) => (e.target.placeholder = "")}
                                                              onBlur={(e) => (e.target.placeholder = "01.........")}
                                                              disabled={isSubmitting}
                                                />
                                                <p className={'form-error'}>{errors.phone?.message}</p>
                                            </Form.Group>
                                        </div>
                                    </div>

                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="secondname">Position</Form.Label>
                                        <Form.Control
                                            type="text"
                                            placeholder="Position"
                                            value={selectedJob?.data?.title}
                                            readOnly
                                            disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.position?.message}</p>
                                    </Form.Group>

                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="cover">Cover Letter*</Form.Label>
                                        <textarea  {...register('cover', {
                                            required: {
                                                value: true,
                                                message: "Please enter your cover letter"
                                            },
                                        })}
                                                   type="text"
                                                   placeholder="My cover letter is..."
                                                   onFocus={(e) => (e.target.placeholder = "")}
                                                   onBlur={(e) => (e.target.placeholder = "My cover letter is...")}
                                                   disabled={isSubmitting}
                                        />
                                        <p className={'form-error'}>{errors.cover?.message}</p>
                                    </Form.Group>
                                    <div className={'buttons d-flex'}>
                                        <Form.Group className={"upload"}>
                                            <Form.Control
                                                ref={cvRef}
                                                onChange={handleUpload}
                                                className={"gph_upload"}
                                                text={uploadText}
                                                type="file"
                                                accept=".pdf"
                                                disabled={isSubmitting}
                                            />
                                        </Form.Group>
                                        <div>
                                            <UploadButton text={uploadText} onClick={handleUploadClick} maxLength={20}/>
                                            {errors.cv && <span className="form-error">{errors.cv.message}</span>}
                                            {cvError && <span className="form-error">{cvError}</span>}
                                        </div>

                                        <div className="button" onClick={handleSubmit(onSubmit)}>
                                            <Button text={'Submit message'} color={'#ffffff'} background={'#001A94'}/>
                                        </div>
                                    </div>
                                </Form>
                            </Col>
                        </Row>
                    </Container>
                </Modal.Body>
            </Modal>
        </StyledComponent>
    );
}
const StyledComponent = styled.section`
    background-color: #f3f3f3;
    position: relative;

    .job-list__title {
        margin-bottom: 40px;
        h4 {
            font-size: 20px;
            line-height: 24px;
            font-weight: 600;
            color: #29253D;
        }

        p {
            font-weight: 300;
            color: #29253D;
        }
    }

    .job-list__item {
        width: 100%;

        &__single {
            width: 100%;
            display: flex;
        }
    }

    .job-list__item {
        margin-top: 60px;
        

        &__single {
            padding-bottom: 40px;
            margin-bottom: 40px;
            position: relative;
            border-bottom: 1px solid #00198f;

            &:after {
                content: "";
                position: absolute;
                bottom: 0;
                left: 15px;
                right: 15px;
                height: 1px;
                background-color: rgba(255, 255, 255, 0.2);
            }
            
            .col-md-3{
                text-align: -webkit-right;
            }
        }

        h4 {
            font-size: 24px;
            line-height: 32px;
            font-weight: 500;
            color: #29253D;
        }

        ul {
            li {
                color: #29253D;
                font-weight: 300;

                span {
                    font-weight: bold;
                }
            }
        }
        
        @media(max-width: 767px){
            &__single{
                .col-md-4{
                    margin-bottom: 30px;
                }
                .col-md-3{
                    text-align: -webkit-left;
                }
            }
        }
    }

    @media (max-width: 991px) {
        .dc-btn {
            margin-top: 30px;
        }

        .job-list__title {
            margin-top: 0px;
        }
    }
    @media (max-width: 767px) {
        .job-list__title {
            h4 {
                padding-right: 0;
                margin-bottom: 20px;
            }
        }
    }
    @media (max-width: 600px) {
        .job-list__item__single {
            flex-wrap: wrap;

            ul {
                margin-top: 20px;
            }
        }
    }
`;

export default JobList;