'use client';
import React from 'react';
import styled from "styled-components";
import {Container, Row, Col, Form} from "react-bootstrap";
import Link from 'next/link'
import Button from "@/components/Button";
import {useRef, useState} from "react";
import {useForm} from "react-hook-form";
import {toast} from "react-toastify";
import axios from "axios";
import reactHtmlParser from "react-html-parser";
import UploadButton from "@/components/career/UploadButton";
import {useGoogleReCaptcha} from "react-google-recaptcha-v3";

const MyComponent = ({data}) => {
    const { executeRecaptcha } = useGoogleReCaptcha();
    const [isSubmit, setIsSubmitting] = useState(false);
    const {register, control, handleSubmit, formState: {errors, isSubmitSuccessful, isSubmitting}, reset} = useForm({
        mode: "all",
    })


    //--- form submit
    const success = (msg) =>
        toast.success(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const error = (msg) =>
        toast.error(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const onSubmit = async (data) => {
        setIsSubmitting(true);
        try {
            const token = await executeRecaptcha('submit');
            const formData = new FormData();
            formData.append('first_name', data?.first_name);
            formData.append('last_name', data?.last_name);
            formData.append('email', data?.email);
            formData.append('phone', data?.phone);
            formData.append('cover', data?.cover);
            formData.append("file", cv);
            formData.append('recaptcha_token', token);
            formData.append('form_id', 'career-form');

            const response = await axios.post('https://project.bestinbd.com/2407NGI/api/post-req-data/form-submit', formData);

            if (response.status === 200) {
                success('Form submitted successfully');
                reset(); // Reset form fields
            } else {
                error('Failed to submit form. Please try again later.');
            }
        } catch (err) {
            error('Failed to submit form. Please try again later.');
        } finally {
            setIsSubmitting(false)
        }
    };


    const [uploadText, setUploadText] = useState('Upload resume');
    const [cv, setCv] = useState(null);
    const [cvError, setCvError] = useState(null);
    const cvRef = useRef();

    const handleUploadClick = () => {
        cvRef.current.click();
    };

    const handleUpload = (event) => {
        const selectedFile = event.target.files[0];

        if (selectedFile) {
            const fileName = selectedFile.name;
            const fileSize = selectedFile.size;
            const fileType = selectedFile.type;

            if (fileType !== 'application/pdf') {
                setCvError('Please upload a PDF file.');
                setUploadText('Upload resume');
                setCv(null);
            } else if (fileSize > 2 * 1024 * 1024) { // 2MB limit
                setCvError('File size should be less than 2MB.');
                setUploadText('Upload resume');
                setCv(null);
            } else {
                setCv(selectedFile);
                setUploadText(fileName);
                setCvError(null);
                document.querySelector('.gph_upload').classList.add('hide');
            }
        }
    };
    return (
        <StyledComponent className={'pt-100 pb-100'}>
            <Container>
                <Row>
                    <Col md={4} className={'contact__left'}>
                        <div className={'contact__left__wrapper'}>
                            <span>{data?.section_data?.subtitle}</span>
                            <h3>
                                {reactHtmlParser(data?.section_data?.short_desc)}
                            </h3>
                        </div>
                    </Col>
                    <Col md={8} className={'contact__right'}>
                        <Form>
                            <div className="form-flex">
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="firstname">First Name*</Form.Label>
                                        <Form.Control
                                            {...register("first_name", {
                                                required: {
                                                    value: true,
                                                    message: "Please enter first name"
                                                },
                                            })}
                                            type="text"
                                            placeholder="John"
                                            disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.first_name?.message}</p>
                                    </Form.Group>
                                </div>
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="secondname">Last Name *</Form.Label>
                                        <Form.Control
                                            {...register("last_name", {
                                                required: {
                                                    value: true,
                                                    message: "Please enter last name"
                                                },
                                            })}
                                            type="text"
                                            placeholder="Doe"
                                            disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.last_name?.message}</p>
                                    </Form.Group>
                                </div>
                            </div>

                            <div className="form-flex">
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="email">Email *</Form.Label>
                                        <Form.Control {...register("email", {
                                            required: 'Please enter your email',
                                            pattern: {
                                                value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                                message: 'Please enter a valid email address',
                                            },
                                        })} type="email" placeholder="your@gmail.com"/>
                                        <p className={'form-error'}>{errors.email?.message}</p>
                                    </Form.Group>
                                </div>
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="phone">Phone Number *</Form.Label>
                                        <Form.Control {...register("phone", {
                                            required: 'Please enter your phone number',
                                            pattern: {
                                                value: /^01[0-9]{9}$/,
                                                message: 'Please enter a valid 11 digit phone number',
                                            },
                                        })} type="number" placeholder="01........."/>
                                        <p className={'form-error'}>{errors.phone?.message}</p>
                                    </Form.Group>
                                </div>
                            </div>

                            <Form.Group className={'form-group'}>
                                <Form.Label htmlFor="cover">Cover Letter*</Form.Label>
                                <textarea  {...register('cover', {
                                    required: {
                                        value: true,
                                        message: "Please enter your cover letter"
                                    },
                                })} type="text" placeholder="My cover letter is..."/>
                                <p className={'form-error'}>{errors.cover?.message}</p>
                            </Form.Group>
                            <div className={'buttons d-flex'}>
                                <Form.Group className={"upload"}>
                                    <Form.Control
                                        ref={cvRef}
                                        onChange={handleUpload}
                                        className={"gph_upload"}
                                        text={uploadText}
                                        type="file"
                                        accept=".pdf"
                                        disabled={isSubmitting}
                                    />
                                </Form.Group>
                                <div>
                                    <UploadButton text={uploadText} onClick={handleUploadClick} maxLength={20}/>
                                    {errors.cv && <span className="form-error">{errors.cv.message}</span>}
                                    {cvError && <span className="form-error">{cvError}</span>}
                                </div>

                                <div className="button" onClick={handleSubmit(onSubmit)}>
                                    <Button text={'Submit message'} color={'#ffffff'} background={'#001A94'}/>
                                </div>
                            </div>
                        </Form>
                    </Col>
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #FFFFFF;

    .contact {
        &__left {
            span {
                color: #000;
                font-size: 14px;
                font-style: normal;
                font-weight: 700;
                line-height: 20px; /* 142.857% */
                position: relative;
                padding-bottom: 10px;
                max-width: 270px;
                display: block;
                margin-bottom: 40px;
                opacity: 0.6;

                &:after {
                    content: '';
                    position: absolute;
                    bottom: 0;
                    left: 0;
                    width: 100%;
                    height: 1px;
                    background-color: #001a95;
                }
            }

            h3 {
                color: #000;
                font-size: 40px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%; /* 48px */
                opacity: 0.6;
            }
        }

        &__right {

            .form-error {
                font-size: 12px;
                line-height: 16px;
                color: #EB1A1A;
            }

            .form-group {
                margin-bottom: 36px;
            }

            .form-flex {
                display: flex;
                gap: 30px;

                .single {
                    width: 50%;
                }
            }

            .form-label {
                margin-bottom: 0 !important;
                color: #001a95;
                font-size: 12px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px; /* 166.667% */
            }

            input {
                border-bottom: 1px solid #001a95 !important;
                color: #000 !important;
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }
                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }
            }

            input:-webkit-autofill,
            input:-webkit-autofill:hover,
            input:-webkit-autofill:focus,
            input:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }

            textarea:-webkit-autofill,
            textarea:-webkit-autofill:hover,
            textarea:-webkit-autofill:focus,
            textarea:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }


            textarea {
                min-height: 250px;
                width: 100%;
                border: none !important;
                border-bottom: 1px solid #001a95 !important;
                background-color: transparent;
                margin-bottom: 5px;
                color: #000 !important;
                font-size: 20px !important;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                border-radius: 0 !important;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }

                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }
            }
            
            .buttons{
                gap: 30px;
            }
            
            .upload{
                display: none;
            }

            .gph_upload {
                position: relative;
                cursor: pointer;
                border: none !important;
                //border-radius: 25px !important;
                overflow: hidden !important;
                padding: 8px 20px;
                text-indent: 0 !important;
                height: 44px !important;
                max-width: 175px !important;
                &.hide {
                    &:before {
                        opacity: 0;
                    }
                }

                &:after {
                    position: absolute;
                    left: 0;
                    right: 0;
                    bottom: 0;
                    top: 0;
                    content: attr(text);
                    border: 1px dashed #137EC3;
                    border-style: dashed;
                    background: #ffffff;
                    z-index: 1;
                    color: #001A94;
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 150% */
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    transition: 0.7s all ease;
                    //padding-left: 20px;
                }


                @media (min-width: 1024px) and (max-width: 1280px) {
                    &:after {
                        //padding-left: 20px;
                    }
                }


                &:hover {
                    &:after {
                        border: 1px #001A94;
                        background: #001A94;
                        color: #ffffff;
                    }
                }
            }
        }
        
        @media(max-width: 767px){
            &__left{
                margin-bottom: 40px;
                h2{
                    color: #00167D;
                    font-size: 36px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%; /* 36px */
                    margin-bottom: 30px;
                }
                p{
                    color: #000;
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 150% */
                }
            }
            
            &__right{
                .form-flex{
                    flex-direction: column;
                    gap: 0;
                    .single{
                        width: 100%;
                    }
                }
                
                .form-group{
                    margin-bottom: 20px;
                }
                
                .form-label{
                    color: #000;
                    font-size: 12px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 20px; /* 166.667% */
                }
                
                input{
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }
                
                textarea{
                    min-height: 170px;
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }

                .buttons{
                    gap: 20px;
                    flex-direction: column !important;
                }
            }
        }
    }


    @media(max-width: 991px){
        .contact__left{
            max-width: 100% !important;
            flex: 0 0 100% !important;
            margin-bottom: 40px;
        }

        .contact__right{
            max-width: 100% !important;
            flex: 0 0 100% !important;
            margin-left: 0 !important;
        }
        
    }
    
`;

export default MyComponent;
