"use client";
import React, {useEffect, useState} from 'react';
import styled from "styled-components";
import {Container, Row, Col, Modal} from "react-bootstrap";
import {Img} from "@/components/Img";
import ImageParallax from "@/components/ImageParallax";
import reactHtmlParser from "react-html-parser";
import {CURSOR_HIDE, CURSOR_SHOW, CURSOR_TEXT, DispatchCursor} from "haspr-cursor";

const MyComponent = ({data,id, img, title, fullWidth, bgTop, bgBottom}) => {
    const [show, setShow] = useState(false);

    const handleClose = () => {
        document.documentElement.classList.remove("modal-open");
        setShow(false);
    }
    const handleShow = () => {
        document.documentElement.classList.add("modal-open");
        setShow(true);
    }


    const [offset, setOffset] = useState(90)


    useEffect(() => {
        const updateOffset = () => setOffset(document.querySelector('.container')?.offsetLeft);

        window.addEventListener('load', updateOffset);
        window.addEventListener('resize', updateOffset);

        updateOffset(); // Initial calculation

        return () => {
            window.removeEventListener('load', updateOffset);
            window.removeEventListener('resize', updateOffset);
        }
    }, []);


    const dispatch = DispatchCursor();

    return (
        <>
            <StyledComponent className={'video-modal'} bgTop={bgTop} bgBottom={bgBottom}>
                {
                    title &&
                    <h2 data-speed={1.1}>{reactHtmlParser(title)}</h2>
                }

                {
                    fullWidth ?
                    <Container fluid>
                        <Row>
                            <Col sm={12}>
                                <div className="video-modal__img ">
                                    <ImageParallax src={img ? img : ''}/>
                                    {
                                        id &&
                                        <div className="video-modal__img__click" onClick={handleShow} onMouseEnter={CURSOR_SHOW} onMouseLeave={CURSOR_HIDE}>
                                            <svg width="32" height="40" viewBox="0 0 32 40">
                                                <path id="Polygon_1" data-name="Polygon 1" d="M20,0,40,32H0Z"
                                                      transform="translate(32) rotate(90)" fill="#fff"/>
                                            </svg>
                                            <span className="circle"/>
                                            <span className="blur"/>
                                        </div>
                                    }
                                </div>
                            </Col>
                        </Row>
                    </Container> :
                        <Container>
                            <Row>
                                <Col sm={12}>
                                    <div className="video-modal__img ">
                                        <ImageParallax src={img ? img : ''}/>
                                        {
                                            id &&
                                            <div className="video-modal__img__click"
                                                 onClick={handleShow}
                                                 onMouseEnter={() => CURSOR_TEXT(dispatch, 'Play', 'WHITE')}
                                                 onMouseLeave={() => CURSOR_TEXT(dispatch, 'END')}
                                            >
                                                <svg width="32" height="40" viewBox="0 0 32 40">
                                                    <path id="Polygon_1" data-name="Polygon 1" d="M20,0,40,32H0Z"
                                                          transform="translate(32) rotate(90)" fill="#fff"/>
                                                </svg>
                                                <span className="circle"/>
                                                <span className="blur"/>
                                            </div>
                                        }
                                    </div>
                                </Col>
                            </Row>
                        </Container>
                }

            </StyledComponent>

            {/*modal*/}
            <Modal className={'modal-video'} show={show} onHide={handleClose}>

                <svg onClick={handleClose} className={'close-modal'} xmlns="http://www.w3.org/2000/svg" width="13.426"
                     height="13.423"
                     viewBox="0 0 13.426 13.423">
                    <path id="Icon_ionic-ios-close" data-name="Icon ionic-ios-close"
                          d="M19.589,18l4.8-4.8A1.124,1.124,0,0,0,22.8,11.616l-4.8,4.8-4.8-4.8A1.124,1.124,0,1,0,11.616,13.2l4.8,4.8-4.8,4.8A1.124,1.124,0,0,0,13.2,24.384l4.8-4.8,4.8,4.8A1.124,1.124,0,1,0,24.384,22.8Z"
                          transform="translate(-11.285 -11.289)" fill="#fff"/>
                </svg>


                <Modal.Body>
                    <iframe width="560" height="315"
                            src={`https://www.youtube.com/embed/${id}?si=H1t21Ym3px2yQicH;controls=0&autoplay=1&rel=0`}
                            title="YouTube video player" frameBorder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowFullScreen/>
                </Modal.Body>

            </Modal>
        </>


    );
};

const StyledComponent = styled.section`
  position: relative;
    z-index: 2;
    background-color: #F3F3F3;
    &:after {
        position: absolute;
        content: '';
        height: 50%;
        bottom: 0;
        width: 100%;
        background-color: ${props => props.bgBottom ? props.bgBottom  : '#ffffff'};
        //z-index: -1;
    }
    
    h2{
        width: max-content;
        position: absolute;
        bottom: -50px;
        left: ${props => props.offset ? props.offset + 'px' : '140px'};
        right: 0;
        color: #001A94;
        font-size: 180px;
        font-style: normal;
        font-weight: 700;
        line-height: 100%; /* 180px */
        z-index: 99999;
        mix-blend-mode: multiply;
        //text-align: center;
    }
    
    .container-fluid{
        padding: 0;
    }

  .title {
    transform: translateY(75%);
    position: relative;
    z-index: 5;
    margin: auto;
    @media (min-width: 768px ) {
      width: 70%;
    }
  }


  .video-modal__img {
    padding-top: calc(600 / 1366 * 100%);
    position: relative;
    cursor: pointer;
    z-index: 2;

    &__click {
      position: absolute;
      inset: 0;
      margin: auto;
      width: 250px;
      height: 250px;
      display: flex;
      align-items: center;
      justify-content: center;


      svg {
        position: relative;
        z-index: 2;
      }

      .circle {
        border: 1px solid #FFF;
        height: 100%;
        width: 100%;
        display: block;
        position: absolute;
        border-radius: 50%;
        transition: 1s cubic-bezier(0.4, 0, 0, 1);
      }

      .blur {
        height: 150px;
        width: 150px;
        position: absolute;
        backdrop-filter: blur(5px);
        border-radius: 50%;
        transition: .6s cubic-bezier(0.4, 0, 0, 1);
        background-color: #ffffff24;
        opacity: 0;
        transform: scale(.1);
      }
    }

    &:hover {
      .circle {
        transform: scale(.1);
      }

      .blur {
        opacity: 1;
        transform: scale(1);
      }
    }
  }

  @media (min-width: 1600px) {
    .col-sm-12 {
      //max-width: 70%;
      //width: 70%;
      margin: auto;
    }
  }

  @media (max-width: 990px) {
    .title {
      transform: none;
    }
  }


  @media (max-width: 991px) {
      
      h2{
          bottom: -20px;
          color: #001A94;
          font-size: 60px;
          font-style: normal;
          font-weight: 700;
          line-height: 100%; /* 60px */
      }
      .row{
          margin: 0 !important;
      }
    .video-modal__img {
      margin-left: -15px;
      margin-right: -15px;
        padding-top: calc(220 / 375 * 100%);

      &__click {
        height: 100px;
        width: 100px;
      }
    }
  }

  @media (max-width: 767px){
      h2{
          left: 15px;
      }
  }  
    
  @media (max-width: 550px) {
    .title {
      text-align: left;
      margin-bottom: 40px;
    }
  }

`;

export default MyComponent;
