'use client';
import styled from "styled-components";
import { Container, Row, Col } from "react-bootstrap";
import Img from "@/components/Img";
import Button from "@/components/Button";
import reactHtmlParser from "react-html-parser";
import PopupV1 from "@/components/PopupV1";
import React, { useState, useRef, useEffect } from "react";

const MyComponent = ({ data }) => {
    const [show, setShow] = useState(false);
    const [popupId, setPopupId] = useState(null);
    const [isOverflowing, setIsOverflowing] = useState({});

    const descriptionRefs = useRef([]);

    const handleClose = () => setShow(false);
    const handleShow = (message) => {
        setShow(true);
        setPopupId(message);
    };

    useEffect(() => {
        // Check if any description is overflowing after 10 lines
        descriptionRefs.current.forEach((ref, index) => {
            if (ref && ref.scrollHeight > ref.clientHeight) {
                setIsOverflowing((prev) => ({ ...prev, [index]: true }));
            } else {
                setIsOverflowing((prev) => ({ ...prev, [index]: false }));
            }
        });
    }, [data]);

    return (
        <StyledComponent className={'message pt-120'}>
            {
                data?.posts?.list && data?.posts?.list?.length > 0 &&
                data?.posts?.list?.map((message, index) => (
                    <Container key={index}>
                        <Row className={'message__top'}>
                            <Col md={{ offset: index % 2 === 0 ? 1 : 0, span: 11 }}>
                                <h2 className={'split-up'}>{message?.data?.short_desc}</h2>
                            </Col>
                        </Row>
                        <Row className={'message__bottom'}>
                            {index % 2 === 0 ? (
                                <>
                                    <Col md={{ offset: 1, span: 4 }} className={'message__bottom__left'}>
                                        <p>{reactHtmlParser(message?.data?.subtitle)}</p>
                                        <div className={'image'}>
                                            <Img src={message?.images?.[0]?.full_path} alt={message?.data?.short_desc} />
                                        </div>
                                    </Col>
                                    <Col md={{ offset: 1, span: 5 }} className={'message__bottom__right'}>
                                        <p ref={el => descriptionRefs.current[index] = el} className={'description'}>
                                            {reactHtmlParser(message?.data?.description)}
                                        </p>
                                        {isOverflowing[index] && (
                                            <div onClick={() => handleShow(message)}>
                                                <Button text={'Read More'} color={'#ffffff'} background={'#001A94'} />
                                            </div>
                                        )}
                                    </Col>
                                </>
                            ) : (
                                <>
                                    <Col md={{ span: 5, offset: 1 }} className={'message__bottom__right'}>
                                        <p ref={el => descriptionRefs.current[index] = el} className={'description'}>
                                            {reactHtmlParser(message?.data?.description)}
                                        </p>
                                        {isOverflowing[index] && (
                                            <div onClick={() => handleShow(message)}>
                                                <Button text={'Read More'} color={'#ffffff'} background={'#001A94'} />
                                            </div>
                                        )}
                                    </Col>
                                    <Col md={{ offset: 1, span: 4 }} className={'message__bottom__left'}>
                                        <p>{message?.data?.subtitle}</p>
                                        <div className={'image'}>
                                            <Img src={message?.images?.[0]?.full_path} alt={message?.data?.short_desc} />
                                        </div>
                                    </Col>
                                </>
                            )}
                        </Row>
                    </Container>
                ))
            }
            <PopupV1 show={show} data={popupId} handleClose={handleClose} />
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #F3F3F3;
    .message {
        &__top {
            padding-bottom: 20px;
            margin-bottom: 20px;
            border-bottom: 1px solid #001a95;
            h2 {
                color: #29253D;
                font-size: 60px;
                font-style: normal;
                font-weight: 700;
                line-height: 100%;
            }
        }
        &__bottom {
            &__left {
                p {
                    color: #29253D;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px;
                    margin-bottom: 40px;
                }
                .image {
                    position: relative;
                    overflow: hidden;
                    padding-top: calc(432 / 370 * 100%);
                }
            }
            &__right {
                padding-top: 60px;
                .description {
                    color: #000;
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px;
                    margin-bottom: 40px;
                    max-height: calc(24px * 15); /* Approximate 10 lines */
                    overflow: hidden;
                    text-overflow: ellipsis;
                    display: -webkit-box;
                    -webkit-line-clamp: 15;
                    -webkit-box-orient: vertical;
                }
            }
        }
    }

    .container {
        &:nth-child(even) {
            margin-top: 120px;
            .message__top{
                h2{
                    text-align: right;
                }
            }
            .message__bottom{
                &__left{
                    p{
                        text-align: right;
                    }
                }
                
                @media (max-width: 767px) {
                    flex-direction: column-reverse;
                }
            }
        }
    }

    @media(max-width: 767px){
        .message{
            &__top{
                padding-bottom: 15px;
                margin-bottom: 15px;
                margin-right: 0;
                margin-left: 0;

                .col-md-11{
                    padding-left: 0;
                    padding-right: 0;
                }
                h2{
                    color: #29253D;
                    font-size: 36px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%;
                }
            }
            &__bottom{
                &__left{
                    p{
                        margin-bottom: 30px;
                    }
                    .image{
                        padding-top: calc(400 / 345 * 100%);
                    }
                }
                &__right{
                    padding-top: 30px;
                    p{
                        margin-bottom: 30px;
                    }
                }
            }
        }
    }
`;

export default MyComponent;
