"use client";
import styled from "styled-components";
import {Container} from "react-bootstrap";
import {Img} from "@/components/SmallImageParallax";
import {Swiper, SwiperSlide} from "swiper/react";
import 'swiper/swiper-bundle.css';
import {Autoplay, EffectCreative, Navigation, Pagination} from "swiper";
import {useState} from "react";
import reactHtmlParser from "react-html-parser";

const MyComponent = ({data}) => {
    const [isBeginning, setIsBeginning] = useState(true);
    const [isEnd, setIsEnd] = useState(false);

    const handleSlideChange = (swiper) => {
        setIsBeginning(swiper.isBeginning);
        setIsEnd(swiper.isEnd);
    };

    console.log('rec', data)
    return (
        <StyledComponent className={'recognition pt-120'}>
            <Container>
                <div className={'recognition__top'}>
                    <h2 className={'split-up'}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                    <div className={'navigation'}>
                        <ul>
                            <li id={'prev-rec'} className={`hover ${isBeginning ? 'disabled' : ''}`}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                            <li id={'next-rec'} className={`hover ${isEnd ? 'disabled' : ''}`}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                        </ul>
                    </div>
                </div>
                <div>
                    {
                        data?.posts?.list &&
                        <Swiper
                            modules={[Autoplay, Pagination, Navigation, EffectCreative]}
                            loop={false}
                            allowTouchMove={true}
                            autoplay={false}
                            slidesPerView={1}
                            spaceBetween={30}
                            pagination={false}
                            navigation={{
                                prevEl: '#prev-rec',
                                nextEl: '#next-rec',
                            }}
                            onSlideChange={handleSlideChange}
                            breakpoints={{
                                900: {
                                    slidesPerView: 3,
                                },
                                550: {
                                    slidesPerView: 1,
                                }

                            }}

                            speed={900}
                        >
                            {
                                data?.posts?.list?.length > 0 &&
                                data?.posts?.list?.map((e,i)=>{
                                    return(
                                        <SwiperSlide key={i}>
                                            <div className={'recognition__single'}>
                                                <div className="recognition__single__img">
                                                    <Img src={e?.images?.[0]?.full_path} alt={e?.data?.title}/>
                                                </div>
                                                <p>{reactHtmlParser(e?.data?.subtitle)}</p>
                                                <h5>{reactHtmlParser(e?.data?.title)}</h5>
                                            </div>
                                        </SwiperSlide>
                                    );
                                })
                            }
                        </Swiper>
                    }
                </div>
                <div className={'mob-navigation'}>
                    <ul>
                        <li id={'prev-rec'} className={`hover ${isBeginning ? 'disabled' : ''}`}>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                 fill="none">
                                <g clipPath="url(#clip0_4006_21)">
                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_4006_21">
                                        <rect width="16.9706" height="16.9706" fill="white"
                                              transform="translate(0.5 0.514648)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </li>
                        <li id={'next-rec'} className={`hover ${isEnd ? 'disabled' : ''}`}>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                 fill="none">
                                <g clipPath="url(#clip0_4006_21)">
                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_4006_21">
                                        <rect width="16.9706" height="16.9706" fill="white"
                                              transform="translate(0.5 0.514648)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </li>
                    </ul>
                </div>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #F3F3F3;
    position: relative;
    overflow: hidden;

    &:after {
        position: absolute;
        content: '';
        height: 50%;
        bottom: 0;
        width: 100%;
        background-color: #ffffff;
        //z-index: -1;
    }

    .recognition {
        &__top {
            margin-bottom: 40px;
            display: flex;
            justify-content: space-between;

            h2 {
                color: #00167D;
                font-size: 60px;
                font-style: normal;
                font-weight: 700;
                line-height: 74px; /* 60px */
            }

            .navigation {
                ul {
                    display: flex;
                    gap: 15px;

                    li {
                        position: relative;
                        overflow: hidden;
                        height: 50px;
                        width: 50px;
                        background-color: rgba(0, 22, 124, 1);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 50%;
                        cursor: pointer;

                        &:after {
                            content: '';
                            position: absolute;
                            height: 0;
                            width: 0;
                            left: 0;
                            right: 0;
                            top: 0;
                            bottom: 0;
                            margin: auto;
                            background-color: #001A94;
                            transition: all .5s ease;
                            border-radius: 50%;
                        }
                        svg{
                            transition: transform 0.3s ease;
                        }

                        &:first-child {
                            svg {
                                transform: rotate(270deg);
                                transition: transform 0.3s ease;
                            }
                        }

                        &:hover {
                            &:after {
                                height: 100%;
                                width: 100%;
                            }
                            svg{
                                position: relative;
                                z-index: 99999;
                                transform: rotate(45deg);
                                transition: transform 0.3s ease;
                            }

                            &:first-child {
                                svg {
                                    transform: rotate(225deg);
                                    transition: transform 0.3s ease;
                                }
                            }
                        }

                        &.disabled {
                            background-color: rgba(0, 22, 124, 1);;
                            cursor: not-allowed;
                            opacity: 0.25;

                            &:hover {
                                &:after {
                                    height: 0;
                                    width: 0;
                                }
                            }
                        }
                    }
                }
            }
        }

        &__single {
            cursor: pointer;
            &__img {
                position: relative;
                overflow: hidden;
                padding-top: calc(300 / 370 * 100%);
                margin-bottom: 30px;
                
                .global-image{
                    img{
                        transform: scale(1);
                        transition: transform 0.4s ease-in-out;
                    }
                }
                &:hover{
                    .global-image{
                        img{
                            transform: scale(1.08);
                            transition: transform 0.4s ease-in-out;
                        }
                    }
                }
            }
            p{
                color: #292929;
                font-size: 14px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px; /* 142.857% */
                text-transform: uppercase;
                margin-bottom: 5px;
            }
            h5{
                color: #292929;
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 120%; /* 28.8px */
            }
        }
    }
    
    .mob-navigation{
        display: none;
       
    }
    
    @media(max-width: 767px){
        .recognition{
            &__top{
                h2{
                    font-size: 36px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%; /* 36px */
                }
                
                .navigation{
                    display: none;
                }
            }
            
            &__single{
                &__img{
                    margin-bottom: 20px;
                }
            }
        }
        
        .mob-navigation{
            display: block;
            margin-top: 40px;
            ul {
                display: flex;
                gap: 15px;

                li {
                    position: relative;
                    overflow: hidden;
                    height: 50px;
                    width: 50px;
                    background-color: rgba(0, 22, 124, 0.25);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 50%;
                    cursor: pointer;
                    z-index: 9;

                    &:after {
                        content: '';
                        position: absolute;
                        height: 0;
                        width: 0;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                        margin: auto;
                        background-color: #001A94;
                        transition: all .5s ease;
                        border-radius: 50%;
                    }

                    &:first-child {
                        svg {
                            transform: rotate(270deg);
                        }
                    }

                    &:hover {
                        &:after {
                            height: 100%;
                            width: 100%;
                        }

                        svg {
                            position: relative;
                            z-index: 99999;
                        }
                    }
                }
            }
        }
    }
`;

export default MyComponent;
