'use client'
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import ImageParallax from "@/components/ImageParallax";
import Button from "@/components/Button";
import {useState} from "react";
import CountUp from "react-countup";
import VisibilitySensor from "react-visibility-sensor";
import reactHtmlParser from "react-html-parser";

const MyComponent = ({data, title, src, pt, pb, counter}) => {
    const [startCounters, setStartCounters] = useState(false);

    const onVisibilityChange = (isVisible) => {
        setStartCounters(isVisible);
    };

    const renderCounter = (end, suffix, description) => (
        <div>
            <CountUp
                start={0}
                end={startCounters ? end : 0}
                duration={2.5}
                separator=","
                decimals={0}
                decimal=","
                suffix={suffix}
            >
                {({ countUpRef }) => (
                    <h4 ref={countUpRef}></h4>
                )}
            </CountUp>
            <p>{description}</p>
        </div>
    );


    return (
        <StyledComponent className={`${pt ? pt : ''} ${pb ? pb : ''} overview`} id={"overview"}>
            <div className={'bg'}>
                <svg xmlns="http://www.w3.org/2000/svg" width="847" height="530" viewBox="0 0 847 530" fill="none" data-speed={1.1}>
                    <mask id="path-1-inside-1_4006_332" fill="white">
                        <path fillRule="evenodd" clipRule="evenodd"
                              d="M855.714 438.211L867.239 422.942V423.23L906.421 509.086C915.353 528.389 900.947 550.285 879.915 549.997L318.97 541.354C308.886 541.066 299.955 535.88 294.769 527.525L121.328 245.756V530.982H0.323242V0H106.923C117.583 0 127.091 5.76215 132.276 14.9816L360.458 428.416C365.355 437.635 374.863 443.397 385.235 443.397L832.378 449.736C841.597 449.736 850.24 445.702 855.714 438.211ZM707.744 111.193C708.086 111.859 707.603 112.65 706.855 112.65H593.852C593.481 112.65 593.141 112.445 592.967 112.117L542.452 16.4482C542.101 15.7822 542.583 14.9812 543.337 14.9812H657.75C658.125 14.9812 658.469 15.191 658.64 15.5246L707.744 111.193ZM445.669 157.883C444.916 157.883 444.433 158.684 444.784 159.35L495.3 255.019C495.473 255.346 495.813 255.552 496.184 255.552H609.187C609.935 255.552 610.418 254.76 610.076 254.095L560.972 158.427C560.801 158.093 560.458 157.883 560.083 157.883H445.669ZM419.519 398.453C405.69 398.453 393.014 390.386 386.963 377.997L238.3 66.265C227.064 42.3521 244.35 14.6938 270.856 14.6938H488.953L541.965 112.362H400.504C389.556 112.362 382.642 123.887 387.828 133.394L472.819 293.006C475.412 297.903 480.31 300.785 485.496 300.785H700.424L625.228 157.883H704.746C717.999 157.883 730.099 165.086 736.438 176.898L826.615 345.441C839.58 369.354 822.006 398.453 794.923 398.453H419.519Z"/>
                    </mask>
                    <path
                        d="M867.239 422.942H868.239V419.957L866.44 422.339L867.239 422.942ZM855.714 438.211L854.916 437.609L854.911 437.615L854.907 437.621L855.714 438.211ZM867.239 423.23H866.239V423.447L866.329 423.645L867.239 423.23ZM906.421 509.086L905.512 509.501L905.514 509.506L906.421 509.086ZM879.915 549.997L879.9 550.997H879.902L879.915 549.997ZM318.97 541.354L318.942 542.354L318.955 542.354L318.97 541.354ZM294.769 527.525L293.917 528.049L293.919 528.052L294.769 527.525ZM121.328 245.756L122.18 245.231L120.328 242.223V245.756H121.328ZM121.328 530.982V531.982H122.328V530.982H121.328ZM0.323242 530.982H-0.676758V531.982H0.323242V530.982ZM0.323242 0V-1H-0.676758V0H0.323242ZM132.276 14.9816L133.152 14.4984L133.148 14.4913L132.276 14.9816ZM360.458 428.416L361.341 427.947L361.337 427.94L361.333 427.933L360.458 428.416ZM385.235 443.397L385.249 442.398L385.242 442.397H385.235V443.397ZM832.378 449.736L832.363 450.736L832.371 450.736H832.378V449.736ZM707.744 111.193L708.634 110.736V110.736L707.744 111.193ZM592.967 112.117L592.083 112.584V112.584L592.967 112.117ZM542.452 16.4482L543.337 15.9812V15.9812L542.452 16.4482ZM658.64 15.5246L657.75 15.9812V15.9812L658.64 15.5246ZM444.784 159.35L443.9 159.817V159.817L444.784 159.35ZM495.3 255.019L496.184 254.552V254.552L495.3 255.019ZM610.076 254.095L610.966 253.638V253.638L610.076 254.095ZM560.972 158.427L561.862 157.97L561.862 157.97L560.972 158.427ZM386.963 377.997L386.061 378.428L386.065 378.436L386.963 377.997ZM238.3 66.265L237.395 66.6903L237.397 66.6955L238.3 66.265ZM488.953 14.6938L489.832 14.2168L489.548 13.6938H488.953V14.6938ZM541.965 112.362V113.362H543.646L542.844 111.885L541.965 112.362ZM387.828 133.394L388.71 132.924L388.705 132.915L387.828 133.394ZM472.819 293.006L473.703 292.538L473.702 292.536L472.819 293.006ZM700.424 300.785V301.785H702.08L701.309 300.319L700.424 300.785ZM625.228 157.883V156.883H623.572L624.343 158.349L625.228 157.883ZM736.438 176.898L737.319 176.427L737.319 176.426L736.438 176.898ZM826.615 345.441L825.734 345.913L825.736 345.918L826.615 345.441ZM866.44 422.339L854.916 437.609L856.513 438.814L868.037 423.544L866.44 422.339ZM868.239 423.23V422.942H866.239V423.23H868.239ZM907.331 508.671L868.148 422.815L866.329 423.645L905.512 509.501L907.331 508.671ZM879.902 550.997C901.665 551.295 916.571 528.641 907.329 508.666L905.514 509.506C914.134 528.137 900.229 549.275 879.929 548.997L879.902 550.997ZM318.955 542.354L879.9 550.997L879.931 548.997L318.986 540.354L318.955 542.354ZM293.919 528.052C299.283 536.694 308.524 542.056 318.942 542.354L318.999 540.354C309.249 540.076 300.627 535.066 295.619 526.997L293.919 528.052ZM120.477 246.28L293.917 528.049L295.621 527.001L122.18 245.231L120.477 246.28ZM122.328 530.982V245.756H120.328V530.982H122.328ZM0.323242 531.982H121.328V529.982H0.323242V531.982ZM-0.676758 0V530.982H1.32324V0H-0.676758ZM106.923 -1H0.323242V1H106.923V-1ZM133.148 14.4913C127.791 4.96726 117.956 -1 106.923 -1V1C117.21 1 126.39 6.55704 131.405 15.4719L133.148 14.4913ZM361.333 427.933L133.152 14.4984L131.401 15.4648L359.582 428.899L361.333 427.933ZM385.235 442.397C375.237 442.397 366.067 436.843 361.341 427.947L359.574 428.885C364.644 438.427 374.489 444.397 385.235 444.397V442.397ZM832.392 448.736L385.249 442.398L385.221 444.397L832.363 450.736L832.392 448.736ZM854.907 437.621C849.636 444.834 841.304 448.736 832.378 448.736V450.736C841.89 450.736 850.845 446.57 856.522 438.802L854.907 437.621ZM706.855 113.65C708.351 113.65 709.317 112.067 708.634 110.736L706.855 111.65V111.65V113.65ZM593.852 113.65H706.855V111.65H593.852V113.65ZM592.083 112.584C592.429 113.239 593.11 113.65 593.852 113.65V111.65V111.65L592.083 112.584ZM541.568 16.9151L592.083 112.584L593.852 111.65L543.337 15.9812L541.568 16.9151ZM543.337 13.9812C541.83 13.9812 540.865 15.5832 541.568 16.9151L543.337 15.9812V15.9812V13.9812ZM657.75 13.9812H543.337V15.9812H657.75V13.9812ZM659.53 15.068C659.187 14.4007 658.5 13.9812 657.75 13.9812V15.9812V15.9812L659.53 15.068ZM708.634 110.736L659.53 15.068L657.75 15.9812L706.855 111.65L708.634 110.736ZM445.669 158.883V158.883V156.883C444.162 156.883 443.197 158.485 443.9 159.817L445.669 158.883ZM496.184 254.552L445.669 158.883L443.9 159.817L494.415 255.486L496.184 254.552ZM496.184 254.552L496.184 254.552L494.415 255.485C494.762 256.141 495.442 256.552 496.184 256.552V254.552ZM609.187 254.552H496.184V256.552H609.187V254.552ZM609.187 254.552V254.552V256.552C610.683 256.552 611.649 254.969 610.966 253.638L609.187 254.552ZM560.083 158.883L609.187 254.552L610.966 253.638L561.862 157.97L560.083 158.883ZM560.083 158.883L560.083 158.883L561.862 157.97C561.519 157.303 560.833 156.883 560.083 156.883V158.883ZM445.669 158.883H560.083V156.883H445.669V158.883ZM386.065 378.436C392.28 391.162 405.301 399.453 419.519 399.453V397.453C406.079 397.453 393.747 389.61 387.862 377.558L386.065 378.436ZM237.397 66.6955L386.061 378.428L387.866 377.567L239.202 65.8346L237.397 66.6955ZM270.856 13.6938C243.607 13.6938 225.851 42.1237 237.395 66.6903L239.205 65.8398C228.276 42.5805 245.093 15.6938 270.856 15.6938V13.6938ZM488.953 13.6938H270.856V15.6938H488.953V13.6938ZM542.844 111.885L489.832 14.2168L488.074 15.1708L541.086 112.839L542.844 111.885ZM400.504 113.362H541.965V111.362H400.504V113.362ZM388.705 132.915C383.891 124.088 390.3 113.362 400.504 113.362V111.362C388.813 111.362 381.393 123.685 386.95 133.873L388.705 132.915ZM473.702 292.536L388.71 132.924L386.945 133.864L471.937 293.476L473.702 292.536ZM485.496 299.785C480.686 299.785 476.125 297.113 473.703 292.538L471.935 293.474C474.699 298.694 479.935 301.785 485.496 301.785V299.785ZM700.424 299.785H485.496V301.785H700.424V299.785ZM624.343 158.349L699.539 301.25L701.309 300.319L626.113 157.418L624.343 158.349ZM704.746 156.883H625.228V158.883H704.746V156.883ZM737.319 176.426C730.806 164.289 718.368 156.883 704.746 156.883V158.883C717.63 158.883 729.392 165.883 735.556 177.371L737.319 176.426ZM827.497 344.969L737.319 176.427L735.556 177.37L825.734 345.913L827.497 344.969ZM794.923 399.453C822.755 399.453 840.825 369.552 827.494 344.965L825.736 345.918C838.335 369.157 821.257 397.453 794.923 397.453V399.453ZM419.519 399.453H794.923V397.453H419.519V399.453Z"
                        fill="#001A94" mask="url(#path-1-inside-1_4006_332)"/>
                </svg>
            </div>
            <Container>
                <Row>
                    <Col md={6} className={'overview__left'}>
                        <h2 className={'split-up'}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                    </Col>
                    <Col md={6} className={'overview__right'}>
                        <h5>
                            {reactHtmlParser(data?.section_data?.short_desc)}
                        </h5>
                        <p>
                            {reactHtmlParser(data?.section_data?.description)}
                        </p>
                        {
                            src &&
                            <Button
                                text={data?.section_data?.button_label}
                                src={data?.section_data?.button_url}
                                background={'#001A94'}
                                color={'#ffffff'}
                                margin={'40px 0 0 0'}
                            />
                        }

                    </Col>
                </Row>
            </Container>
            <Container className={'counter'}>
                <Row className={'counter-box'}>
                    <Col md={6} className={'counter-box__left'}>
                        <div className={'image-wrapper'}>
                            <ImageParallax src={counter?.images?.list?.[0]?.full_path}/>
                        </div>
                    </Col>
                    <Col md={6} className={'counter-box__right'}>
                        <VisibilitySensor
                            onChange={onVisibilityChange}
                            partialVisibility={{ top: 0, bottom: 20 }}
                            delayedCall
                        >
                            <div>
                                <div className="counter-box__right__top">
                                    <div className="counter-box__right__top__left">
                                        {renderCounter(`${counter?.posts?.list?.[0]?.data?.short_desc}`, '', `${counter?.posts?.list?.[0]?.data?.subtitle}`)}
                                    </div>
                                    <div className="counter-box__right__top__right">
                                        {renderCounter(`${counter?.posts?.list?.[1]?.data?.short_desc}`, '', `${counter?.posts?.list?.[1]?.data?.subtitle}`)}
                                    </div>
                                </div>
                                <div className="counter-box__right__bottom">
                                    {renderCounter(`${counter?.posts?.list?.[2]?.data?.short_desc}`, '+', `${counter?.posts?.list?.[2]?.data?.subtitle}`)}
                                </div>
                            </div>
                        </VisibilitySensor>
                    </Col>
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    //padding-top: 100px;
    background: #F3F3F3;
    -webkit-backdrop-filter: blur(15px);
    backdrop-filter: blur(15px);
    position: relative;
    overflow: hidden;

    .bg {
        position: absolute;
        bottom: 25%;
        right: 0;

        svg {
            strokeWidth: 1px !important;
            stroke: #001A94;
            opacity: 0.1;
        }
    }
    .overview {
        &__left {
            padding-right: 30px;
            h2 {
                color: #001A94;
                font-size: 60px;
                font-style: normal;
                font-weight: 700;
                line-height: 73px;
            }
        }

        &__right {
            h5 {
                color: #29253D;
                font-size: 24px;
                font-style: normal;
                font-weight: 400;
                line-height: 32px;
                padding-bottom: 40px;
            }

            p {
                color: #29253D;
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }
            ul,ol{
                display: flex;
                flex-direction: column;
                li{
                    color: #FFF;
                    padding-bottom: 10px;
                    margin-bottom: 10px;
                    border-bottom: 1px solid #f8f8f8;
                    position: relative;
                    padding-left: 20px;

                    &::after{
                        content: '';
                        position: absolute;
                        top: 40%;
                        left: 0px;
                        width: 5px;
                        height: 5px;
                        border-radius: 50%;
                        background-color: white;
                        transform: translateY(-50%);
                    }
                }
            }
        }
    }
    
    .counter{
        margin-top: 100px;
        //background-color: #ffffff;
        .counter-box{
            &__left{
                padding: 0 0 0 15px;
                .image-wrapper{
                    height: 100%;
                    position: relative;
                    //padding-top: calc(400 / 585 * 100%);
                    overflow: hidden;
                }
            }
            &__right{
                padding: 0 15px 0 0;
                
                &__top{
                    background-color: #ffffff;
                    display: flex;
                    h4{
                        color: #001A94;
                        font-size: 80px;
                        font-style: normal;
                        font-weight: 700;
                        line-height: 100%; /* 80px */
                        margin-bottom: 28px;
                    }
                    p{
                        color: #001A94;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                    &__left{
                        flex: 1;
                        padding: 40px 34px;
                        border-right: 1px solid rgba(0, 26, 148, 0.25);
                    }
                    &__right{
                        flex: 1;
                        padding: 40px 34px;
                    }
                }
                &__bottom{
                    background-color: #ffffff;
                    padding: 34px 30px;
                    border-top: 1px solid rgba(0, 26, 148, 0.25);
                    h4{
                        color: #001A94;
                        font-size: 80px;
                        font-style: normal;
                        font-weight: 700;
                        line-height: 100%; /* 80px */
                        margin-bottom: 28px;
                    }
                    p{
                        color: #001A94;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }
            }
        }
    }

    @media(max-width: 991px){
        .bg{
            bottom: 50%;
            width: max-content;
        }
        .overview{
            &__left{
                max-width: 100% !important;
                flex: 0 0 100%;
                margin-bottom: 30px;
                h2{
                    font-size: 36px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%;
                }
            }
            &__right{
                max-width: 100% !important;
                flex: 0 0 100%;
                h5{
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 28px; /* 140% */
                    padding-bottom: 30px;
                }
                p{
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 150% */
                }
            }
        }
        
        .counter{
            margin-top: 60px;
            background-color: unset;
            .row{
                margin: 0 !important;
            }
            .counter-box {
                &__left{
                    max-width: 100%;
                    flex: 0 0 100%;
                }
                &__right{
                    padding: 0;
                    max-width: 100%;
                    flex: 0 0 100%;
                    &__top{
                        &__left{
                            flex: 1;
                            width: 50%;
                            padding: 30px 16px !important;
                            h4{
                                font-size: 42px !important;
                                font-style: normal;
                                font-weight: 700;
                                line-height: 100%; /* 42px */
                            }
                            p{
                                font-size: 16px !important;
                                font-style: normal;
                                font-weight: 400;
                                line-height: 22px; /* 137.5% */
                            }
                        }
                        &__right{
                            flex: 1;
                            width: 50%;
                            padding: 30px 16px !important;
                            h4{
                                font-size: 42px !important;
                                font-style: normal;
                                font-weight: 700;
                                line-height: 100%; /* 42px */
                            }
                            p{
                                font-size: 16px !important;
                                font-style: normal;
                                font-weight: 400;
                                line-height: 22px; /* 137.5% */
                            }
                        }
                    }
                    &__bottom{
                        h4{
                            font-size: 42px !important;
                            font-style: normal;
                            font-weight: 700;
                            line-height: 100%; /* 42px */
                        }
                        p{
                            font-size: 16px !important;
                            font-style: normal;
                            font-weight: 400;
                            line-height: 22px; /* 137.5% */
                        }
                    }
                }
            }
        }
    }
`;

export default MyComponent;
