'use client';
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import Link from 'next/link'
import NewsCard from "@/components/News/NewsCard";
import Button from "@/components/Button";
import {useEffect, useState} from "react";

const MyComponent = ({data}) => {
    const [visibleItems, setVisibleItems] = useState(6);
    const [hasMore, setHasMore] = useState(false);

    useEffect(() => {
        setHasMore(data?.length > visibleItems);
    }, [data, visibleItems]);

    const loadMore = () => {
        setVisibleItems(prevVisible => prevVisible + 6);
    };
    return (
        <StyledComponent className="pt-200 pb-120">
            <Container>
                <Row>
                    {data && data.slice(0, visibleItems).map((e, i) => {
                        const date = new Date(e?.data?.date);
                        const options = { year: 'numeric', month: 'short', day: 'numeric' };
                        const formattedDate = date.toLocaleDateString('en-US', options);
                        return (
                            <Col md={4} key={i}>
                                <NewsCard
                                    title={e?.data?.title}
                                    date={formattedDate}
                                    img={e?.images?.list?.find(f => f?.thumb === 'on')?.full_path}
                                    link={e?.data?.slug}
                                />
                            </Col>
                        );
                    })}
                    {hasMore && (
                        <Col md={12}>
                            <div className="loadmore">
                                <Button
                                    text={'Load More'}
                                    background={'#001A94'}
                                    color={'#ffffff'}
                                    onClick={loadMore}
                                />
                            </div>
                        </Col>
                    )}
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`

    .col-md-4{
        margin-bottom: 40px;
    }

    .loadmore {
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
        
        .dc-btn{
            width: max-content;
        }
    }
    
    
    @media(max-width: 991px){
        
    }
`;

export default MyComponent;
