'use client';
import styled from "styled-components";
import Link from 'next/link'
import {Img} from "@/components/SmallImageParallax";

const MyComponent = ({img, date, title, link}) => {
    return (
        <StyledComponent>
            <Link href={`/news-media/${link ? link : ''}`} prefetch={true}>
            <div className={'img-wrapper'}>
                <Img src={img} alt={title}/>
            </div>
            <p className={'date'}>{date}</p>
            <h5>{title}</h5>
            <p className={'btn'}>
                Read More
                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="18" viewBox="0 0 17 18" fill="none">
                    <path d="M4.24268 13.2426L12.728 4.75727" stroke="#001A94" strokeWidth="1.5" strokeLinecap="round"
                          strokeLinejoin="round"/>
                    <path d="M12.7279 13.2426V4.75727H4.24262" stroke="#001A94" strokeWidth="1.5"
                          strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
            </p>
            </Link>
        </StyledComponent>
    );
};

const StyledComponent = styled.div`
    border-bottom: 1px solid #001a95;
    height: 100%;
    .img-wrapper {
        position: relative;
        padding-top: calc(280 / 370 * 100%);
        overflow: hidden;
        margin-bottom: 30px;

        .global-image{
            img{
                transform: scale(1);
                transition: transform 0.4s ease-in-out;
            }
        }
        
        &:hover{
            .global-image{
                img{
                    transform: scale(1.05);
                    transition: transform 0.4s ease-in-out;
                }
            }
        }
    }

    .date {
        color: #292929;
        font-size: 14px;
        font-style: normal;
        font-weight: 400;
        line-height: 20px; /* 142.857% */
        text-transform: uppercase;
    }
    h5{
        color: #292929;
        font-size: 24px;
        font-style: normal;
        font-weight: 400;
        line-height: 120%; /* 28.8px */
        margin-bottom: 30px;
    }
    
    .btn{
        color: #001A94 !important;
        font-size: 16px;
        font-style: normal;
        font-weight: 400;
        line-height: 24px; /* 150% */
        padding: 0;
        margin-bottom: 30px;
        svg{
            margin-left: 10px;
            transition: 0.3s all ease-in-out;
            
        }
        
        &:hover{
            svg{
                transform: rotate(45deg);
                transition: 0.3s all ease-in-out;
            }
        }
    }
`;

export default MyComponent;
