"use client";
import {useEffect, useState} from 'react';
import styled from "styled-components";
import {Container, Row, Col, Modal} from "react-bootstrap";
import {Img} from "@/components/Img";
import ImageParallax from "@/components/ImageParallax";
import reactHtmlParser from "react-html-parser";

const MyComponent = ({img, title}) => {


    const [offset, setOffset] = useState(90)


    useEffect(() => {
        const updateOffset = () => setOffset(document.querySelector('.container')?.offsetLeft);

        window.addEventListener('load', updateOffset);
        window.addEventListener('resize', updateOffset);

        updateOffset(); // Initial calculation

        return () => {
            window.removeEventListener('load', updateOffset);
            window.removeEventListener('resize', updateOffset);
        }
    }, []);


    return (
        <>
            <StyledComponent offset={offset}>
                {
                    title &&
                    <h1 data-speed={1.1}>{reactHtmlParser(title)}</h1>
                }

                <ImageParallax src={img ? img : ''}/>

            </StyledComponent>
        </>


    );
};

const StyledComponent = styled.section`
    position: relative;
    padding-top: calc(450 / 1366 * 100%);
    z-index: 2;
    background-color: #F3F3F3;

    h1{
        width: max-content;
        position: absolute;
        bottom: -40px;
        left: ${props => props.offset ? props.offset + 'px' : '140px'};
        right: 0;
        color: #001A94;
        font-size: 140px;
        font-style: normal;
        font-weight: 700;
        line-height: 100%; /* 180px */
        z-index: 99999;
        mix-blend-mode: multiply;
        //text-align: center;
    }
    
    @media(max-width: 767px){
        padding-top: 100%;
        height: 50svh;
        h1{
            left: 15px;
            font-size: 70px;
            bottom: -30px !important;
        }
    }


    @media(max-width: 991px) and (min-width: 768px){
        padding-top: 100%;
        height: 50svh;
        h1{
            left: ${props => props.offset ? props.offset + 'px' : '140px'};
            font-size: 80px;
            bottom: -10px !important;
        }
    }

`;

export default MyComponent;
