'use client'
import React from 'react';
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import reactHtmlParser from "react-html-parser";
import {Img} from "@/components/Img";
import ImageParallax from "@/components/ImageParallax";

const InnerBanner = ({img, text, title, data}) => {
    return (
        <StyledInnerBanner className='InnerBanner'>
            <ImageParallax banner={true} src={data?.images?.list?.[0]?.full_path}/>
            <Container>
                <Row>
                    <Col md={12}>
                        <div className="title">
                            <h1 className={`split-up`} data-speed={1.1}>{data?.section_data?.subtitle ? reactHtmlParser(data?.section_data?.subtitle) : ''}</h1>
                        </div>
                    </Col>
                </Row>
            </Container>
        </StyledInnerBanner>
    );
};

const StyledInnerBanner = styled.section`
    padding-top: calc(450 / 1366 * 100%);
    position: relative;
    //overflow: hidden;

    &:after {
        content: '';
        position: absolute;
        background-color: rgba(0, 0, 0, 0.2);
        height: 100%;
        width: 100%;
        left: 0;
        top: 0;
    }
    .container {
        position: absolute;
        height: 100%;
        top: 0;
        left: 0;
        right: 0;
        //z-index: 2;
        padding: 0;
    }
    
    .row{
        height: 100%;
    }

    .title{
        height: 100%;
        display: flex;
        justify-content: flex-start;
        align-items: flex-end;
    }
    
    h1 {
        color: #001A94;
        font-size: 120px;
        font-style: normal;
        font-weight: 700;
        line-height: 100%; /* 68px */
        z-index: 2;
        text-align: center;
        margin-bottom: -30px;
        mix-blend-mode: multiply;
    }


    @media (max-width: 767px) {
        //padding-top: 0;
        padding-top: calc(450 / 375 * 100%);
        .container {
            //bottom: 60px !important;
            //top: unset !important;
            padding: 0 15px !important;
        }
        
        .row{
            align-content: flex-end;
            gap: 30px;
        }
        
        .col-md-3{
            height: auto !important;
            .content{
                position: unset !important;
            }
        }
        
        h1{
            color: #001A94;
            font-size: 40px !important;
            font-style: normal;
            font-weight: 700;
            line-height: 100%; /* 40px */
        }
        
    }

    @media (max-width: 991px) {
        //padding-top: 0;
        padding-top: calc(450 / 375 * 100%);
        .container {
            //bottom: 60px !important;
            //top: unset !important;
            padding: 0 15px !important;
        }

        .row{
            align-content: flex-end;
            gap: 30px;
        }

        .col-md-3{
            max-width: 100%;
            flex: 0 0 100%;
            margin-left: 0 !important;
            height: auto !important;
            .content{
                position: unset !important;
            }
        }

        h1{
            color: #001A94;
            font-size: 70px;
            font-style: normal;
            font-weight: 700;
            line-height: 100%; /* 40px */
            margin-bottom: -20px;
        }

    }
`;

export default InnerBanner;
