"use client";
import React, {useEffect, useState} from "react";
import styled from 'styled-components';
import blur from "@/public/images/static/blur.svg";

const ImageParallax = ({src, srcSm, alt, objectFit, position,height, width, banner, left, margin, right, top, bottom}) => {

    const [deviceWidth, setDeviceWidth] = useState(0);

    // set device width
    useEffect(() => {
        function HandleWidth() {
            setDeviceWidth(window.innerWidth)
        }

        window.addEventListener('resize', HandleWidth)
        HandleWidth()
        return () => {
            window.removeEventListener('resize', HandleWidth)
        };
    });

    return (
        <StyledImg className='global-image' objectFit={objectFit} margin={margin} position={position} left={left}
                   right={right} top={top}
                   bottom={bottom} height={height} width={width}>
            <img data-speed={0.8} src={src ? deviceWidth > 600 ? src : srcSm ? srcSm : src : blur} alt={alt || ''}/>
        </StyledImg>
    );
};

const StyledImg = styled.div`
  position: ${props => props.position || 'absolute'};
  height: ${props => props.height || '100%'};
  width: ${props => props.width || '100%'};
  top: ${props => props.top || 0};
  left: ${props => props.left || 0};
  bottom: ${props => props.bottom || 0};
  right: ${props => props.right || 0};
  margin: ${props => props.margin || 0};
    overflow: hidden;

  img {
    width: 100%;
    height: 110%;
    object-fit: ${props => props.objectFit || 'cover'};
    position: absolute;
      top: -30px;
    left: 0;
    right: 0;
    bottom: 0;
      
      @media (max-width: 767px) {
          top: 0 !important;
      }
      
      @media(max-width: 991px) {
          
      }
  }
}`;

export default ImageParallax;