'use client';
import React, {useEffect, useState} from 'react';
import {GoogleMap, LoadScript, Marker, InfoWindow, StyledMap} from '@react-google-maps/api';
import styled from 'styled-components';
import Button from "@/components/Button";


const GoogleMapsMarkers = ({data}) => {

    const mapStyles = {
        height: '100%',
        width: '100%',
    };

    const defaultCenter = {
        lat: 23.801927, // Replace with marker latitude
        lng: 90.4029675, // Replace with marker longitude
    };

    const [selectedMarker, setSelectedMarker] = useState(null);


    const map = data && data?.map((i,e)=>{

    })

    const marker = data && Array.isArray(data) ? data.map((item, index) => {
        const section = item?.sections?.filter((f=>f?.section_data?.template === 'map'));
        return {
            id: index,
            position: {lat: parseFloat(section?.[0]?.section_data?.latitude), lng: parseFloat(section?.[0]?.section_data?.longitude)},
            icon: '/images/static/map-svg.svg',
            title: section?.[0]?.section_data?.subtitle,
            address: section?.[0]?.section_data?.short_desc,
            slug: 'luxury-apartment-complex',
        };
    }) : [];



    // const markers = [
    //     {
    //         id: 1,
    //         position: { lat: 23.8079771957636, lng: 90.42124095339209 },
    //         icon: '/images/static/map-svg.svg',
    //         title: 'Nasir Corporate Office',
    //         address: '85, Suhrawardy Avenue, Baridhara Diplomatic Zone, Dhaka.',
    //         slug: 'luxury-apartment-complex',
    //     },
    //
    //     {
    //         id: 2,
    //         position: { lat: 24.297993478265536, lng: 90.38949108539767},
    //         icon: '/images/static/map-svg.svg',
    //         title: 'Nasir Glassware & Tube Industries Ltd.',
    //         address: 'Nasir glass industries limited, Gazipur 1740',
    //         slug: 'luxury-apartment-complex',
    //     },
    //
    // ];


    const handleMarkerClick = (marker) => {
        setSelectedMarker(marker);
    };

    const handleInfoWindowClose = () => {
        setSelectedMarker(null);
    };


    const customMapStyle = [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#f5f5f5"
                }
            ]
        },
        {
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#f5f5f5"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#bdbdbd"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#eeeeee"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#e5e5e5"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#ffffff"
                }
            ]
        },
        {
            "featureType": "road.arterial",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dadada"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#e5e5e5"
                }
            ]
        },
        {
            "featureType": "transit.station",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#eeeeee"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#c9c9c9"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        }
    ]; // Paste your copied JSON style here

    const mapOptions = {
        styles: customMapStyle,
    };


    const [selectedMarkerId, setSelectedMarkerId] = useState(null);
    const handleButtonClick = (selectedId) => {

        setSelectedMarkerId(selectedId)
    };
    const handleButtonClickClose = () => {
        setSelectedMarkerId(null)
    };

    const [mapLoaded, setMapLoaded] = useState(false);

    const handleMapButtonClick = () => {
        setMapLoaded(true);
    };

    const [mapCenter, setMapCenter] = useState({ lat: 0, lng: 0 });

    useEffect(() => {
        // Calculate the center point between the two markers
        const averageLat = marker.reduce((sum, marker) => sum + marker.position.lat, 0) / marker.length;
        const averageLng = marker.reduce((sum, marker) => sum + marker.position.lng, 0) / marker.length;
        setMapCenter({ lat: averageLat, lng: averageLng });
    }, []);





    return (
        <StyledComponent>
            {!mapLoaded && (
                <div className={"map-overlay"}>
                    <div className="map-overlay__btn" onClick={handleMapButtonClick} style={{width: "fit-content"}}>
                        <Button margin={"0"} text={"Click to load the map"} color={'#001A94'}/>
                    </div>
                    {/*// <button onClick={handleMapButtonClick}>Load Map</button>*/}
                </div>

            )}
            {
                mapLoaded ?
                    <>
                        <LoadScript googleMapsApiKey="AIzaSyB3nEqKsliw_EQSpaxAq6R8hOUwpGyxJ9s"
                                    onLoad={() => console.log('Google Maps API loaded successfully')}
                                    onError={(error) => console.error('Error Laoding Google Map', error)}
                        >
                            <GoogleMap
                                mapContainerStyle={mapStyles}
                                zoom={9}
                                center={defaultCenter}
                                options={mapOptions}
                            >
                                {marker.map((marker) => (
                                    <Marker
                                        key={marker.id}
                                        position={marker.position}
                                        icon={marker.icon}
                                        onClick={() => handleMarkerClick(marker)}
                                    />
                                ))}
                                {selectedMarker && (
                                    <InfoWindow
                                        position={selectedMarker.position}
                                        onCloseClick={handleInfoWindowClose}
                                    >
                                        <div style={{cursor: "pointer"}} data-id={selectedMarker.id}
                                             onClick={() => handleButtonClick(selectedMarker.id)}>
                                            <h6>{selectedMarker.title}</h6>
                                            <p>{selectedMarker.address}</p>
                                            {
                                                window?.innerWidth > 767 &&
                                                <div className={'map-button'}
                                                >
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16.707"
                                                         height="11.414"
                                                         viewBox="0 0 16.707 11.414">
                                                        <g id="Arrow" transform="translate(-1307.5 -242.793)">
                                                            <line id="Line_12400" data-name="Line 12400" x2="5" y2="5"
                                                                  transform="translate(1318.5 243.5)" fill="none"
                                                                  stroke="#f1eee9"
                                                                  strokeLinecap="round" strokeWidth="1"/>
                                                            <line id="Line_12401" data-name="Line 12401" y1="5" x2="5"
                                                                  transform="translate(1318.5 248.5)" fill="none"
                                                                  stroke="#f1eee9"
                                                                  strokeLinecap="round" strokeWidth="1"/>
                                                            <line id="Line_12402" data-name="Line 12402" x2="15"
                                                                  transform="translate(1308 248.5)" fill="none"
                                                                  stroke="#f1eee9"
                                                                  strokeLinecap="round" strokeWidth="1"/>
                                                        </g>
                                                    </svg>

                                                </div>
                                            }
                                        </div>
                                    </InfoWindow>
                                )}

                            </GoogleMap>
                        </LoadScript>
                    </> :
                    null
            }
        </StyledComponent>

    );
};

const StyledComponent = styled.section`
  height: 600px;
  position: relative;
  overflow: hidden;

  .map-overlay {
    position: absolute;
    height: 100%;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;

    .dc-btn {
      position: relative;
      z-index: 3;
    }

    &:after {
      content: '';
      background-image: url('/images/static/map-loader.png');
      position: absolute;
      height: 100%;
      width: 100%;
      inset: 0;
    }

    &:before {
      content: '';
      background-color: rgba(0, 0, 0, 0.73);
      position: absolute;
      height: 100%;
      width: 100%;
      inset: 0;
      z-index: 2;
    }
  }

  .map-button {
    cursor: pointer;

    svg {
      transform: translateX(0);
      transition: transform 0.6s cubic-bezier(0.76, 0, 0.24, 1);
    }

    &:hover {
      svg {
        transform: translateX(10px);
      }
    }
  }

  .google-map-side-gallery {
    .item-single-gallery {
      background: #011887;
      right: 0;
      top: 0;
      bottom: 0;
      z-index: 2;
      position: absolute;
      padding: 40px;
      transform: translateX(100%);
      min-width: 468px;
      transition: transform 0.6s cubic-bezier(0.76, 0, 0.24, 1);

      .close-modal-map {
        position: absolute;
        right: 20px;
        top: 20px;
        cursor: pointer;
      }

      .content {
        height: calc(70vh - 60px);
        overflow-x: scroll;
        /* Hide scrollbar for IE, Edge and Firefox */
        -ms-overflow-style: none; /* IE and Edge */
        scrollbar-width: none; /* Firefox */

        &::-webkit-scrollbar {
          display: none;
        }


        h4 {
          font-size: 20px;
          font-weight: 500;
          line-height: 24px;
          color: #F1EEE9;
          text-transform: uppercase;
          width: 60%;
          margin-bottom: 40px;
        }

        ul {
          display: flex;
          flex-direction: column;
          margin-bottom: 40px;

          li {
            margin-bottom: 10px;
            margin-bottom: 10px;
            display: inline-flex;

            svg {
              height: 20px;
              width: 20px;
              margin-right: 20px;
            }

            p {
              font-size: 12px;
              line-height: 24px;
              color: #F1EEE9;
              text-transform: uppercase;
              margin: 0;
              width: 30%;

              &:last-child {

              }
            }

            &:last-child {
              margin-bottom: 0;
            }
          }
        }
      }

      .gallery {
        ul {
          margin: 0;
          gap: 15px;
          flex-wrap: wrap;
          flex-direction: unset;

          li {
            flex: 0 0 calc(50% - 15px);
            margin: 0;

            .react_lightgallery_item {
              width: 100%;
              cursor: pointer;
            }

            .img-wrapper {
              padding-top: calc(100 / 160 * 100%);
              position: relative;
              min-height: 100px;
            }
          }
        }
      }

      &.active {
        transform: translateX(0);
      }


    }
  }
    
    .gm-style-iw-chr{
        height: 20px !important;
        button{
            span{
                background-color: #ffffff !important;
            }
        }
    }

    .gm-style .gm-style-iw-c {
        position: absolute;
        box-sizing: border-box;
        overflow: hidden;
        top: 0px;
        left: 0px;
        background-color: #011887;
        box-shadow: rgba(0, 0, 0, 0.3) 0px 2px 7px 1px;
        min-height: 125px !important;
        padding: 0px !important;
        min-width: 370px !important;
        
        .gm-style-iw-d{
            padding: 0 20px 0px 20px;
            scrollbar-width: none;
            overflow: hidden;
            h6{
                color: #FFF;
                font-size: 14px;
                font-style: normal;
                font-weight: 700;
                line-height: 24px; /* 171.429% */
            }
            p{
                color: #FFF;
                font-size: 12px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 200% */
                margin-bottom: 20px;
            }
        }

        &::after{
            background: #011887 !important;
        }
    }

    .gm-style .gm-style-iw-tc::after{
        background: #011887 !important;
    }


    .poi-info-window div, .poi-info-window a {
    background: transparent;
    color: #F1EEE9;

  }
`;
export default GoogleMapsMarkers;