"use client"
import React, {useCallback, useEffect, useState} from 'react';
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import Link from "next/link";
import {getConcernApi, getFooterApi} from "@/api/api";
import reactHtmlParser from "react-html-parser";


const Footer = () => {
    const year = new Date().getFullYear();
    const [getSettings, setSettings] = useState(null);
    const [getConcerns, setConcerns] = useState(null);
    useEffect(() => {
        const fetchSetting = async () => {
            const data = await getFooterApi();
            setSettings(data);
        };

        fetchSetting();
    }, []);

    useEffect(() => {
        const fetchSetting = async () => {
            const data = await getConcernApi();
            setConcerns(data);
        };

        fetchSetting();
    }, []);

    return (
        <StyledComponent className="footer">
            <div className={'bg'}>
                <svg xmlns="http://www.w3.org/2000/svg" width="847" height="530" viewBox="0 0 847 530" fill="none">
                    <mask id="path-1-inside-1_4006_332" fill="white">
                        <path fillRule="evenodd" clipRule="evenodd"
                              d="M855.714 438.211L867.239 422.942V423.23L906.421 509.086C915.353 528.389 900.947 550.285 879.915 549.997L318.97 541.354C308.886 541.066 299.955 535.88 294.769 527.525L121.328 245.756V530.982H0.323242V0H106.923C117.583 0 127.091 5.76215 132.276 14.9816L360.458 428.416C365.355 437.635 374.863 443.397 385.235 443.397L832.378 449.736C841.597 449.736 850.24 445.702 855.714 438.211ZM707.744 111.193C708.086 111.859 707.603 112.65 706.855 112.65H593.852C593.481 112.65 593.141 112.445 592.967 112.117L542.452 16.4482C542.101 15.7822 542.583 14.9812 543.337 14.9812H657.75C658.125 14.9812 658.469 15.191 658.64 15.5246L707.744 111.193ZM445.669 157.883C444.916 157.883 444.433 158.684 444.784 159.35L495.3 255.019C495.473 255.346 495.813 255.552 496.184 255.552H609.187C609.935 255.552 610.418 254.76 610.076 254.095L560.972 158.427C560.801 158.093 560.458 157.883 560.083 157.883H445.669ZM419.519 398.453C405.69 398.453 393.014 390.386 386.963 377.997L238.3 66.265C227.064 42.3521 244.35 14.6938 270.856 14.6938H488.953L541.965 112.362H400.504C389.556 112.362 382.642 123.887 387.828 133.394L472.819 293.006C475.412 297.903 480.31 300.785 485.496 300.785H700.424L625.228 157.883H704.746C717.999 157.883 730.099 165.086 736.438 176.898L826.615 345.441C839.58 369.354 822.006 398.453 794.923 398.453H419.519Z"/>
                    </mask>
                    <path
                        d="M867.239 422.942H868.239V419.957L866.44 422.339L867.239 422.942ZM855.714 438.211L854.916 437.609L854.911 437.615L854.907 437.621L855.714 438.211ZM867.239 423.23H866.239V423.447L866.329 423.645L867.239 423.23ZM906.421 509.086L905.512 509.501L905.514 509.506L906.421 509.086ZM879.915 549.997L879.9 550.997H879.902L879.915 549.997ZM318.97 541.354L318.942 542.354L318.955 542.354L318.97 541.354ZM294.769 527.525L293.917 528.049L293.919 528.052L294.769 527.525ZM121.328 245.756L122.18 245.231L120.328 242.223V245.756H121.328ZM121.328 530.982V531.982H122.328V530.982H121.328ZM0.323242 530.982H-0.676758V531.982H0.323242V530.982ZM0.323242 0V-1H-0.676758V0H0.323242ZM132.276 14.9816L133.152 14.4984L133.148 14.4913L132.276 14.9816ZM360.458 428.416L361.341 427.947L361.337 427.94L361.333 427.933L360.458 428.416ZM385.235 443.397L385.249 442.398L385.242 442.397H385.235V443.397ZM832.378 449.736L832.363 450.736L832.371 450.736H832.378V449.736ZM707.744 111.193L708.634 110.736V110.736L707.744 111.193ZM592.967 112.117L592.083 112.584V112.584L592.967 112.117ZM542.452 16.4482L543.337 15.9812V15.9812L542.452 16.4482ZM658.64 15.5246L657.75 15.9812V15.9812L658.64 15.5246ZM444.784 159.35L443.9 159.817V159.817L444.784 159.35ZM495.3 255.019L496.184 254.552V254.552L495.3 255.019ZM610.076 254.095L610.966 253.638V253.638L610.076 254.095ZM560.972 158.427L561.862 157.97L561.862 157.97L560.972 158.427ZM386.963 377.997L386.061 378.428L386.065 378.436L386.963 377.997ZM238.3 66.265L237.395 66.6903L237.397 66.6955L238.3 66.265ZM488.953 14.6938L489.832 14.2168L489.548 13.6938H488.953V14.6938ZM541.965 112.362V113.362H543.646L542.844 111.885L541.965 112.362ZM387.828 133.394L388.71 132.924L388.705 132.915L387.828 133.394ZM472.819 293.006L473.703 292.538L473.702 292.536L472.819 293.006ZM700.424 300.785V301.785H702.08L701.309 300.319L700.424 300.785ZM625.228 157.883V156.883H623.572L624.343 158.349L625.228 157.883ZM736.438 176.898L737.319 176.427L737.319 176.426L736.438 176.898ZM826.615 345.441L825.734 345.913L825.736 345.918L826.615 345.441ZM866.44 422.339L854.916 437.609L856.513 438.814L868.037 423.544L866.44 422.339ZM868.239 423.23V422.942H866.239V423.23H868.239ZM907.331 508.671L868.148 422.815L866.329 423.645L905.512 509.501L907.331 508.671ZM879.902 550.997C901.665 551.295 916.571 528.641 907.329 508.666L905.514 509.506C914.134 528.137 900.229 549.275 879.929 548.997L879.902 550.997ZM318.955 542.354L879.9 550.997L879.931 548.997L318.986 540.354L318.955 542.354ZM293.919 528.052C299.283 536.694 308.524 542.056 318.942 542.354L318.999 540.354C309.249 540.076 300.627 535.066 295.619 526.997L293.919 528.052ZM120.477 246.28L293.917 528.049L295.621 527.001L122.18 245.231L120.477 246.28ZM122.328 530.982V245.756H120.328V530.982H122.328ZM0.323242 531.982H121.328V529.982H0.323242V531.982ZM-0.676758 0V530.982H1.32324V0H-0.676758ZM106.923 -1H0.323242V1H106.923V-1ZM133.148 14.4913C127.791 4.96726 117.956 -1 106.923 -1V1C117.21 1 126.39 6.55704 131.405 15.4719L133.148 14.4913ZM361.333 427.933L133.152 14.4984L131.401 15.4648L359.582 428.899L361.333 427.933ZM385.235 442.397C375.237 442.397 366.067 436.843 361.341 427.947L359.574 428.885C364.644 438.427 374.489 444.397 385.235 444.397V442.397ZM832.392 448.736L385.249 442.398L385.221 444.397L832.363 450.736L832.392 448.736ZM854.907 437.621C849.636 444.834 841.304 448.736 832.378 448.736V450.736C841.89 450.736 850.845 446.57 856.522 438.802L854.907 437.621ZM706.855 113.65C708.351 113.65 709.317 112.067 708.634 110.736L706.855 111.65V111.65V113.65ZM593.852 113.65H706.855V111.65H593.852V113.65ZM592.083 112.584C592.429 113.239 593.11 113.65 593.852 113.65V111.65V111.65L592.083 112.584ZM541.568 16.9151L592.083 112.584L593.852 111.65L543.337 15.9812L541.568 16.9151ZM543.337 13.9812C541.83 13.9812 540.865 15.5832 541.568 16.9151L543.337 15.9812V15.9812V13.9812ZM657.75 13.9812H543.337V15.9812H657.75V13.9812ZM659.53 15.068C659.187 14.4007 658.5 13.9812 657.75 13.9812V15.9812V15.9812L659.53 15.068ZM708.634 110.736L659.53 15.068L657.75 15.9812L706.855 111.65L708.634 110.736ZM445.669 158.883V158.883V156.883C444.162 156.883 443.197 158.485 443.9 159.817L445.669 158.883ZM496.184 254.552L445.669 158.883L443.9 159.817L494.415 255.486L496.184 254.552ZM496.184 254.552L496.184 254.552L494.415 255.485C494.762 256.141 495.442 256.552 496.184 256.552V254.552ZM609.187 254.552H496.184V256.552H609.187V254.552ZM609.187 254.552V254.552V256.552C610.683 256.552 611.649 254.969 610.966 253.638L609.187 254.552ZM560.083 158.883L609.187 254.552L610.966 253.638L561.862 157.97L560.083 158.883ZM560.083 158.883L560.083 158.883L561.862 157.97C561.519 157.303 560.833 156.883 560.083 156.883V158.883ZM445.669 158.883H560.083V156.883H445.669V158.883ZM386.065 378.436C392.28 391.162 405.301 399.453 419.519 399.453V397.453C406.079 397.453 393.747 389.61 387.862 377.558L386.065 378.436ZM237.397 66.6955L386.061 378.428L387.866 377.567L239.202 65.8346L237.397 66.6955ZM270.856 13.6938C243.607 13.6938 225.851 42.1237 237.395 66.6903L239.205 65.8398C228.276 42.5805 245.093 15.6938 270.856 15.6938V13.6938ZM488.953 13.6938H270.856V15.6938H488.953V13.6938ZM542.844 111.885L489.832 14.2168L488.074 15.1708L541.086 112.839L542.844 111.885ZM400.504 113.362H541.965V111.362H400.504V113.362ZM388.705 132.915C383.891 124.088 390.3 113.362 400.504 113.362V111.362C388.813 111.362 381.393 123.685 386.95 133.873L388.705 132.915ZM473.702 292.536L388.71 132.924L386.945 133.864L471.937 293.476L473.702 292.536ZM485.496 299.785C480.686 299.785 476.125 297.113 473.703 292.538L471.935 293.474C474.699 298.694 479.935 301.785 485.496 301.785V299.785ZM700.424 299.785H485.496V301.785H700.424V299.785ZM624.343 158.349L699.539 301.25L701.309 300.319L626.113 157.418L624.343 158.349ZM704.746 156.883H625.228V158.883H704.746V156.883ZM737.319 176.426C730.806 164.289 718.368 156.883 704.746 156.883V158.883C717.63 158.883 729.392 165.883 735.556 177.371L737.319 176.426ZM827.497 344.969L737.319 176.427L735.556 177.37L825.734 345.913L827.497 344.969ZM794.923 399.453C822.755 399.453 840.825 369.552 827.494 344.965L825.736 345.918C838.335 369.157 821.257 397.453 794.923 397.453V399.453ZM419.519 399.453H794.923V397.453H419.519V399.453Z"
                        fill="#001A94" mask="url(#path-1-inside-1_4006_332)"/>
                </svg>
            </div>
            <Container>
                <Row className={'footer-top'}>
                    <Col md={2} className={'social'}>
                        <ul>
                            {
                                getSettings?.data?.facebook &&
                                <li>
                                    <a href={getSettings?.data?.facebook} target="_blank" rel="noopener noreferrer">
                                        <svg width="7" height="12" viewBox="0 0 7 12" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M6.00369 6.75003L6.33686 4.57828H4.25456V3.16916C4.24031 3.00704 4.26265 2.84378 4.3199 2.69144C4.37715 2.5391 4.46787 2.40155 4.58537 2.28894C4.70286 2.17633 4.84414 2.09153 4.99878 2.04079C5.15341 1.99006 5.31742 1.97468 5.47879 1.9958H6.42627V0.148278C5.87048 0.0579652 5.30888 0.00840617 4.74586 0C3.02931 0 1.90781 1.03793 1.90781 2.92302V4.57828H0V6.75003H1.90781V12H4.25552V6.75003H6.00369Z"
                                                fill="#ffffff"/>
                                        </svg>

                                    </a>
                                </li>
                            }
                            {
                                getSettings?.data?.twitter &&
                                <li>
                                    <a href={getSettings?.data?.twitter} target="_blank" rel="noopener noreferrer">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path fillRule="evenodd" clipRule="evenodd"
                                                  d="M12 12L7.30724 5.00618L7.31525 5.01273L11.5465 0H10.1325L6.68564 4.08L3.94841 0H0.240103L4.62125 6.52965L4.62072 6.5291L0 12H1.41396L5.24607 7.46073L8.29169 12H12ZM3.38817 1.09091L9.97243 10.9091H8.85194L2.26235 1.09091H3.38817Z"
                                                  fill="#ffffff"/>
                                        </svg>

                                    </a>
                                </li>
                            }

                            {
                                getSettings?.data?.instagram &&
                                <li>
                                    <a href={getSettings?.data?.instagram} target="_blank" rel="noopener noreferrer">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path fillRule="evenodd" clipRule="evenodd"
                                                  d="M3.60444 11.9995H8.3955C9.35114 11.9984 10.2674 11.6184 10.9431 10.9426C11.6188 10.2669 11.9989 9.35067 12 8.39503V3.60398C11.9988 2.64842 11.6186 1.73235 10.9429 1.05671C10.2672 0.38108 9.35106 0.0010528 8.3955 0H3.60444C2.64888 0.0010528 1.73281 0.38108 1.05708 1.05671C0.381351 1.73235 0.00118465 2.64842 0 3.60398V8.39503C0.00105305 9.35067 0.381155 10.2669 1.0569 10.9426C1.73264 11.6184 2.64879 11.9984 3.60444 11.9995ZM1.85537 1.85552C2.31947 1.3915 2.9487 1.13054 3.60498 1.12988H8.39599C9.05227 1.13054 9.6815 1.3915 10.1456 1.85552C10.6097 2.31953 10.8708 2.94869 10.8716 3.60497V8.39602C10.8709 9.05239 10.6099 9.68168 10.1458 10.1458C9.68167 10.6099 9.05235 10.871 8.39599 10.8716H3.60498C2.94862 10.871 2.31931 10.6099 1.85519 10.1458C1.39106 9.68168 1.13004 9.05239 1.12938 8.39602V3.60497C1.13017 2.94869 1.39126 2.31953 1.85537 1.85552ZM9.17766 2.1427C9.03846 2.1426 8.90237 2.18379 8.78659 2.26105C8.6708 2.33831 8.58053 2.44818 8.52719 2.57675C8.47385 2.70533 8.45985 2.84683 8.48694 2.98337C8.51404 3.1199 8.58105 3.24533 8.67944 3.34379C8.77783 3.44226 8.90322 3.50933 9.03973 3.53652C9.17625 3.56371 9.31773 3.5498 9.44634 3.49656C9.57495 3.44331 9.68491 3.35312 9.76226 3.23739C9.8396 3.12166 9.88088 2.98559 9.88088 2.84639C9.88095 2.754 9.86277 2.66251 9.82746 2.57714C9.79215 2.49177 9.74039 2.41419 9.67509 2.34884C9.60978 2.28349 9.53224 2.23164 9.44689 2.19627C9.36154 2.1609 9.27004 2.1427 9.17766 2.1427ZM6.05045 3.04492C5.46605 3.04502 4.89482 3.2184 4.40895 3.54313C3.92308 3.86787 3.54438 4.32938 3.32079 4.86932C3.09719 5.40925 3.03872 6.00336 3.15275 6.57653C3.26679 7.14969 3.54819 7.67617 3.96142 8.08941C4.37465 8.50264 4.90118 8.78407 5.47434 8.8981C6.04751 9.01214 6.64159 8.95366 7.18153 8.73006C7.72146 8.50647 8.18298 8.1278 8.50772 7.64193C8.83245 7.15606 9.00584 6.58481 9.00593 6.00041C9.00515 5.21681 8.6935 4.46553 8.13941 3.91144C7.58532 3.35735 6.83405 3.04571 6.05045 3.04492ZM6.05045 7.89316C5.6761 7.89316 5.31015 7.78215 4.99889 7.57417C4.68763 7.36619 4.44506 7.07059 4.3018 6.72473C4.15854 6.37888 4.12102 5.99831 4.19405 5.63116C4.26708 5.264 4.44735 4.92674 4.71206 4.66204C4.97676 4.39733 5.31401 4.21706 5.68117 4.14403C6.04833 4.071 6.42894 4.10848 6.7748 4.25174C7.12065 4.395 7.41622 4.6376 7.6242 4.94886C7.83218 5.26012 7.94321 5.62606 7.94321 6.00041C7.94268 6.50223 7.74308 6.98336 7.38823 7.3382C7.03339 7.69305 6.55227 7.89263 6.05045 7.89316Z"
                                                  fill="#ffffff"/>
                                        </svg>

                                    </a>
                                </li>
                            }

                            {
                                getSettings?.data?.linkedin &&
                                <li>
                                    <a href={getSettings?.data?.linkedin} target="_blank" rel="noopener noreferrer">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10.313" height="10.313"
                                             viewBox="0 0 10.313 10.313">
                                            <g id="linkedin" transform="translate(14456.5 18494.5)">
                                                <path id="Path_9063" data-name="Path 9063"
                                                      d="M44.965,42.352V38.575c0-1.856-.4-3.275-2.565-3.275a2.239,2.239,0,0,0-2.024,1.109H40.35v-.941H38.3v6.884h2.14V38.936c0-.9.168-1.766,1.276-1.766s1.109,1.018,1.109,1.818v3.352h2.14Z"
                                                      transform="translate(-14491.151 -18526.539)" fill="#ffffff"/>
                                                <path id="Path_9064" data-name="Path 9064"
                                                      d="M11.3,36.6h2.14v6.884H11.3Z"
                                                      transform="translate(-14467.633 -18527.672)" fill="#ffffff"/>
                                                <path id="Path_9065" data-name="Path 9065"
                                                      d="M11.238,10a1.244,1.244,0,1,0,1.238,1.238A1.238,1.238,0,0,0,11.238,10Z"
                                                      transform="translate(-14466.5 -18504.5)" fill="#ffffff"/>
                                            </g>
                                        </svg>
                                    </a>
                                </li>
                            }

                            {
                                getSettings?.data?.youtube &&
                                <li>
                                    <a href={getSettings?.data?.youtube} target="_blank" rel="noopener noreferrer">
                                        <svg width="12" height="10" viewBox="0 0 12 10" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M12 3.43315C12 3.08733 11.9319 2.7449 11.7995 2.42541C11.6672 2.10592 11.4733 1.81562 11.2287 1.57109C10.9842 1.32656 10.6939 1.13259 10.3744 1.00026C10.0549 0.867918 9.71249 0.799805 9.36668 0.799805H2.63339C1.93499 0.799805 1.26518 1.07725 0.771336 1.57109C0.277488 2.06494 0 2.73474 0 3.43315V6.56684C0 7.26525 0.277488 7.93505 0.771336 8.4289C1.26518 8.92275 1.93499 9.20019 2.63339 9.20019H9.36668C9.71249 9.20019 10.0549 9.13208 10.3744 8.99974C10.6939 8.8674 10.9842 8.67343 11.2287 8.4289C11.4733 8.18437 11.6672 7.89408 11.7995 7.57458C11.9319 7.25509 12 6.91266 12 6.56684V3.43315ZM8.04067 5.23464L5.02103 6.72836C4.903 6.79217 4.50034 6.7069 4.50034 6.57193V3.50544C4.50034 3.36933 4.90582 3.28349 5.02385 3.35126L7.91417 4.92348C8.0339 4.99294 8.16322 5.168 8.04067 5.23464Z"
                                                fill="#ffffff"/>
                                        </svg>

                                    </a>
                                </li>
                            }
                        </ul>
                    </Col>
                    <Col md={{span: 3, offset: 1}} className={'info'}>
                        <ul>
                            {
                                getSettings?.data?.office_location &&
                                <li className="office">
                                    <p>Head Office</p>
                                    <a href={`https://www.google.com/maps?q=${getSettings?.data?.office_location}`}
                                       target={'_blank'} rel="noopener noreferrer">
                                        {getSettings?.data?.office_location}
                                    </a>
                                </li>
                            }

                            {
                                getSettings?.data?.office_phone &&
                                <li className="phone">
                                    <p>Phone Number</p>
                                    <a href={`tel:${getSettings?.data?.office_phone}`} target={'_blank'}
                                       rel="noopener noreferrer">
                                        {getSettings?.data?.office_phone}
                                    </a>
                                </li>
                            }

                            {
                                getSettings?.data?.contact_email &&
                                <li className="email">
                                    <p>Email</p>
                                    <a href={`mailto:${getSettings?.data?.contact_email}`} target={'_blank'}
                                       rel="noopener noreferrer">
                                        {getSettings?.data?.contact_email}
                                    </a>
                                </li>
                            }
                        </ul>
                    </Col>
                    <Col md={{span: 2, offset: 1}} className={'menu'}>
                        <ul>
                            <p>Menu</p>
                            <li>
                                <Link href={'/'} prefetch={true}>
                                    Home
                                </Link>
                            </li>
                            <li>
                                <Link href={'/about-us'} prefetch={true}>
                                    About Us
                                </Link>
                            </li>
                            <li>
                                <Link href={'/industries'} prefetch={true}>
                                    Industries
                                </Link>
                            </li>
                            <li>
                                <Link href={'/career'} prefetch={true}>
                                    Career
                                </Link>
                            </li>
                            <li>
                                <Link href={'/news-media'} prefetch={true}>
                                    News & Media
                                </Link>
                            </li>
                            <li>
                                <Link href={'/contact-us'} prefetch={true}>
                                    Contact Us
                                </Link>
                            </li>
                        </ul>
                    </Col>
                    <Col md={3} className={'menu concern'}>
                        <div>
                            <p>Industries</p>
                            <div className={'logo-grid'}>
                                {
                                    getConcerns?.data?.list && getConcerns?.data?.list?.length > 0 &&
                                    getConcerns?.data?.list?.map((item, index) => {
                                        return (
                                            <div className="logo-single" key={index}>
                                                <Link href={`/industries/${item?.page_data?.slug}`} prefetch={true}>
                                                    <img
                                                        src={item?.images?.list?.find(f => f?.icon === 'on')?.full_path}/>
                                                    <div className="tooltip">
                                                        <p>{reactHtmlParser(item?.page_data?.title)}</p>
                                                    </div>
                                                </Link>
                                            </div>
                                        );
                                    })
                                }
                            </div>
                        </div>
                    </Col>
                </Row>
                <div className={'footer-bottom'}>
                    <p>
                        © {year}, Nasir Group. All Rights Reserved.
                    </p>
                    <p>
                        <a target="_blank" href="https://dcastalia.com/">
                            <span>Site by Dcastalia</span>
                            <img src="/images/static/dc_logo.svg" alt=""/>
                        </a>
                    </p>
                </div>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    padding-top: 100px;
    background: #E9E9E9;
    backdrop-filter: blur(15px);
    position: relative;
    overflow: hidden;

    .bg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;

        svg {
            strokeWidth: 1px !important;
            stroke: #001A94;
            opacity: 0.1;
        }
    }

    .footer-top {
        .social {
            ul {
                display: flex;
                gap: 10px;

                li {

                    a {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        height: 25px;
                        width: 25px;
                        border-radius: 50%;
                        border: 1px solid #29253D;
                        margin-bottom: 10px;
                        background-color: #29253D;
                        transition: background-color .5s ease;
                        position: relative;

                        img {
                            height: 10px;
                            transition: .3s ease;
                            filter: invert(95%) sepia(100%) saturate(44%) hue-rotate(256deg) brightness(234%) contrast(162%);
                        }
                    }

                    &:hover {
                        a {
                            background-color: #001A94;
                            border: 1px solid #001A94;

                            img {
                                filter: invert(95%) sepia(100%) saturate(44%) hue-rotate(256deg) brightness(234%) contrast(162%);
                            }
                        }
                    }

                    button {
                        position: absolute;
                        inset: 0;
                        z-index: 2;
                        cursor: pointer;
                    }
                }
            }
        }

        .info {
            ul {
                display: flex;
                flex-direction: column;
                gap: 30px;

                li {
                    p {
                        font-size: 14px;
                        line-height: 20px;
                        font-weight: 400;
                        color: #29253D;
                        margin-bottom: 10px;
                    }

                    a {
                        color: #29253D;
                        font-size: 14px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 20px;
                    }
                }
            }
        }

        .menu {
            p {
                color: #29253D;
                font-size: 14px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px; /* 142.857% */
                margin-bottom: 15px;
            }

            ul {
                display: flex;
                flex-direction: column;
                gap: 10px;

                li {
                    a {
                        color: #29253D;
                        font-size: 14px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 20px; /* 142.857% */
                    }
                }
            }


            .logo-grid {
                display: flex;
                flex-wrap: wrap;
                justify-content: flex-start;
                align-items: center;

                .logo-single {
                    flex: 1 1 calc(25%) !important;
                    max-width: 25%;
                    margin-bottom: 15px;
                    
                    a{
                        position: relative;
                        width: 40px;
                        height: 40px;
                        padding: 8px;
                        border: 1px solid white;
                        border-radius: 50%;
                        background-color: white;
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        img{
                            width: 30px;
                            height: 30px;
                        }

                        .tooltip{
                            position: absolute;
                            bottom: calc(100% + 15px);
                            right: 0px;
                            background: #001A94;
                            color: white;
                            font-size: 12px;
                            line-height: 16px;
                            width: max-content;
                            max-width: 250px;
                            min-width: 80px;
                            padding: 20px;
                            text-align: center;
                            opacity: 0;
                            pointer-events: none;
                            transition: opacity .3s ease-in-out;

                            p{
                                color: white;
                                margin-bottom: 0;
                            }

                            &:after{
                                content: "";
                                position: absolute;
                                top: 100%;
                                right: 30px;
                                width: 0;
                                height: 0;
                                border-top: 12px solid #001A94;
                                border-left: 10px solid rgba(0, 0, 0, 0);
                            }
                        }
                        &:hover{
                            .tooltip{
                                opacity: 1;
                                transition: opacity .3s ease-in-out;
                            }
                        }
                    }
                    
                }
                
                @media(max-width: 767px){
                    .logo-single{
                        a{
                            .tooltip{
                                display: none !important;
                            }
                        }
                    }
                }
            }
        }
    }

    .footer-bottom {
        padding-top: 110px;
        padding-bottom: 40px;
        display: flex;
        justify-content: space-between;
        position: relative;

        p {
            color: #292929;
            font-size: 14px;
            font-style: normal;
            font-weight: 400;
            line-height: 20px; /* 142.857% */

            a {
                color: #292929;
                span{
                    margin-right: 5px;
                }
            }
        }
    }


    @media (max-width: 991px) {
        padding-top: 60px;

        .bg {
            top: unset !important;
            bottom: 0 !important;
            width: auto !important;
            height: auto !important;
        }

        .footer-top {
            .social {
                margin-bottom: 30px;
                max-width: 100% !important;
                flex: 0 0 100% !important;
            }

            .info {
                margin-bottom: 30px;
                margin-left: 0 !important;
                max-width: 33% !important;
                flex: 0 0 33% !important;
            }

            .menu {
                margin-bottom: 30px;
                margin-left: 0 !important;
                max-width: 33% !important;
                flex: 0 0 33% !important;
            }
        }

        .footer-bottom {
            padding-top: 0px;
            padding-bottom: 40px;
            flex-direction: column;
        }
    }


    @media (max-width: 767px) {
        padding-top: 60px;

        .bg {
            top: unset !important;
            bottom: 0 !important;
            width: 80%;
            height: 30%;
        }

        .footer-top {
            .social {
                margin-bottom: 30px;
                max-width: 100% !important;
                flex: 0 0 100% !important;

            }

            .info {
                margin-bottom: 30px;
                max-width: 60% !important;
                flex: 0 0 60% !important;
            }

            .menu {
                margin-bottom: 30px;
                max-width: 40% !important;
                flex: 0 0 40% !important;
            }

            .concern {
                margin-bottom: 30px;
                max-width: 100% !important;
                flex: 0 0 100% !important;

            }
        }

        .footer-bottom {
            padding-top: 0px;
            padding-bottom: 40px;
            flex-direction: column;
        }
    }
`;

export default Footer;
