'use client';
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import Link from 'next/link'
import {Img} from "@/components/SmallImageParallax";
import Button from "@/components/Button";
import reactHtmlParser from "react-html-parser";

const MyComponent = ({data}) => {

    return (
        <StyledComponent className={'pb-120'}>
            <Container fluid className={'concern'}>
                {
                    data && data?.length > 0 &&
                    data?.map((concern,index) =>{
                        return(
                            <Row className={'concern__single'} key={index}>
                                <Col md={4} className={index % 2 !== 0 ? 'offset-md-4' : ''}>
                                    <div className={'concern__single__img'}>
                                        <Img src={concern.images?.list?.find(f=>f?.thumb === 'on')?.full_path}/>
                                    </div>
                                </Col>
                                <Col md={4}>
                                    <div className={'concern__single__content'}>
                                        <div className="top">
                                            <h4 className={'split-up'}>{reactHtmlParser(concern?.page_data?.title)}</h4>
                                            <p>{reactHtmlParser(concern?.page_data?.short_desc)}</p>
                                        </div>
                                        <div className="bottom">
                                            <Link href={`/industries/${concern?.page_data?.slug}`} prefetch={true}>
                                                <p>Explore Industry</p>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="18" viewBox="0 0 17 18" fill="none">
                                                    <path d="M4.24268 13.2426L12.728 4.75727" stroke="#001A94" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                                                    <path d="M12.728 13.2426V4.75727H4.24275" stroke="#001A94" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                                                </svg>
                                            </Link>
                                        </div>
                                    </div>
                                </Col>
                            </Row>
                        );
                    })
                }
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #F3F3F3;
    .concern {
        padding: 0;

        &__single {
            .col-md-4{
                padding-left: 0;
                padding-right: 0;
            }
            &__img{
                position: relative;
                overflow: hidden;
                padding-top: calc(455 / 500 * 100%);
            }
            
            &__content{
                height:  100%;
                padding: 80px 60px;
                background-color: #ffffff;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                .top{
                    h4{
                        color: #292929;
                        font-size: 32px;
                        font-style: normal;
                        font-weight: 700;
                        line-height: 120%; /* 38.4px */
                        margin-bottom: 30px;
                    }
                    
                    p{
                        color: #000;
                        font-size: 14px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 20px; /* 142.857% */
                    }
                }
                .bottom{
                    a{
                        display: flex;
                        align-items: center;
                        gap: 10px;
                        
                        p{
                            color: #001A94;
                            font-size: 16px;
                            font-style: normal;
                            font-weight: 400;
                            line-height: 24px; /* 150% */
                        }
                        svg{
                            transition: 0.3s all ease-in-out;
                        }
                        
                        &:hover{
                            svg{
                                transform: rotate(45deg);
                                transition: 0.3s all ease-in-out;
                            }
                        }
                    }
                }
            }
        }
    }
    
    

    @media(max-width: 991px){
        padding-top: 80px;
        .container{
            padding-right: 15px;
            padding-left: 15px;
        }

        .row{
            margin-right: 15px;
            margin-left: 15px;
            margin-bottom: 15px;
        }

        .concern{
            &__single{
                .col-md-4{
                    max-width: 50% !important;
                    flex: 0 0 50% !important;
                    margin-left: 0 !important;
                }
                &__img{
                    padding-top: calc(345 / 300 * 100%);
                }

                &__content{
                    padding: 30px 20px;
                    gap: 40px;

                    .top{
                        h4{
                            font-size: 24px;
                            font-style: normal;
                            font-weight: 700;
                            line-height: 120%; /* 28.8px */
                        }
                    }
                }
                
                &:nth-child(even){
                    flex-direction: row-reverse;
                }
            }
        }
    }

    @media(max-width: 767px){
        padding-top: 80px;
        .container{
            padding-right: 15px;
            padding-left: 15px;
        }

        .row{
            margin-right: 15px;
            margin-left: 15px;
            margin-bottom: 15px;
        }

        .concern{
            &__single{
                .col-md-4{
                    max-width: unset !important;
                    flex: unset !important;
                    margin-left: 0 !important;
                }
                &__img{
                    padding-top: calc(345 / 300 * 100%);
                }

                &__content{
                    padding: 30px 20px;
                    gap: 40px;

                    .top{
                        h4{
                            font-size: 24px;
                            font-style: normal;
                            font-weight: 700;
                            line-height: 120%; /* 28.8px */
                        }
                    }
                }
            }
        }
    }
`;

export default MyComponent;
