// Page data
export async function getApi(param) {
    const response = await fetch(
        `https://project.bestinbd.com/2407NGI/api/get-req-data/sections?type=slug&value=${param}&get_section=yes&image=yes&post=yes&file=yes&gallery=yes`,
        {
            cache: "no-store"
        }
    );
    if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();
    return data;
}


// Blog Details data
export async function getBlogDetailApi(param) {
    const response = await fetch(
        `https://project.bestinbd.com/2407NGI/api/get-req-data/blog-data?type=slug&value=${param}`,
        {
            cache: "no-store"
        }
    );
    if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
    }
    const blog = await response.json();
    return blog;
}


// Footer data
export async function getFooterApi() {
    const response = await fetch(
        `https://project.bestinbd.com/2407NGI/api/get-req-data/settings-data`,
        {
            cache: "no-store"
        }
    );
    if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
    }
    const footer = await response.json();
    return footer;
}

// Concern List
export async function getConcernApi() {
    const response = await fetch(
        `https://project.bestinbd.com/2407NGI/api/get-req-data/child-pages?page_id=4&image=yes&post=yes&file=yes&gallery=yes&sections=yes`,
        {
            cache: "no-store"
        }
    );
    if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
    }
    const footer = await response.json();
    return footer;
}

// Menu
    export async function getMenuApi() {
        const response = await fetch(
            `https://project.bestinbd.com/2407NGI/api/get-req-data/menu-data?menu_id=1`,
            {
                cache: "no-store"
            }
        );
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        const menu = await response.json();
        return menu;
    }